﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Kolory
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            trackBar1_ValueChanged(null, null);
        }

        private void zapiszUstawienia()
        {
            Properties.Settings ustawienia = new Properties.Settings();
            ustawienia.R = (byte)trackBar1.Value;
            ustawienia.G = (byte)trackBar2.Value;
            ustawienia.B = (byte)trackBar3.Value;
            ustawienia.Szerokość = this.Width;
            ustawienia.Wysokość = this.Height;
            ustawienia.Left = this.Left;
            ustawienia.Top = this.Top;
            ustawienia.Save();
        }

        private void wczytajUstawienia()
        {
            Properties.Settings ustawienia = new Properties.Settings();
            trackBar1.Value = ustawienia.R;
            trackBar2.Value = ustawienia.G;
            trackBar3.Value = ustawienia.B;
            this.Width = ustawienia.Szerokość;
            this.Height = ustawienia.Wysokość;
            this.Left = ustawienia.Left;
            this.Top = ustawienia.Top;
        }

        private void trackBar1_ValueChanged(object sender, EventArgs e)
        {
            panel1.BackColor = Color.FromArgb(trackBar1.Value, trackBar2.Value, trackBar3.Value);
            label4.Text = trackBar1.Value.ToString();
            label5.Text = trackBar2.Value.ToString();
            label6.Text = trackBar3.Value.ToString();

            /*
            if (sender != null)
            {
                (sender as TrackBar).BackColor = Color.Firebrick;                
            }
            */
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            DialogResult dr = MessageBox.Show(
                "Czy jesteś pewien?",
                this.Text,
                MessageBoxButtons.YesNo,
                MessageBoxIcon.Question,
                MessageBoxDefaultButton.Button2);

            if (dr == DialogResult.No) e.Cancel = true;
        }

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            zapiszUstawienia();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            wczytajUstawienia();
        }

        private void Form1_KeyDown(object sender, KeyEventArgs e)
        {
            if(e.KeyCode == Keys.C && e.Control)
            {
                Clipboard.SetText("#" + 
                    trackBar1.Value.ToString("X2") +
                    trackBar2.Value.ToString("X2") +
                    trackBar3.Value.ToString("X2"));
            }
        }
    }
}
