﻿using System;

namespace AsystentZakupowUA.Model
{
    public class AutoSumowanie
    {
        private decimal limit;
        private decimal suma;

        public AutoSumowanie(decimal limit, decimal suma = 0)
        {
            this.limit = limit;
            this.suma = suma;
            BieżącaInstancja = this;
        }

        public void Dodaj(decimal kwota)
        {
            if (!CzyKwotaPoprawna(kwota)) 
                throw new ArgumentOutOfRangeException("Kwota zbyt duża lub ujemna");
            suma += kwota;
        }

        public decimal Suma
        {
            get
            {
                return suma;
            }
        }

        public decimal Limit
        {
            get
            {
                return limit;
            }
        }

        private bool czyPrzekroczyLimit(decimal kwota)
        {
            return suma + kwota > limit;
        }

        public bool CzyKwotaPoprawna(decimal kwota)
        {
            return kwota > 0 && !czyPrzekroczyLimit(kwota);
        }

        public static AutoSumowanie BieżącaInstancja { get; set; }
    }
}
