﻿using System;
using System.Collections.Generic;
using System.Text;
using Windows.Storage;

namespace AsystentZakupowUA.Model
{
    using AsystentZakupowUA.Model;
using System.Threading.Tasks;

    public static class Ustawienia
    {
        private const string kluczLimitu = "Limit";
        private const string kluczSumy = "Suma";

        private static ApplicationDataContainer ustawienia
        {
            get
            {
                return ApplicationData.Current.LocalSettings;
            }
        }

        public static void ZapiszStanModelu(AutoSumowanie model)
        {
            ustawienia.Values[kluczLimitu] = model.Limit.ToString();
            ustawienia.Values[kluczSumy] = model.Suma.ToString();
        }

        public static AutoSumowanie OdczytajStanModelu(decimal domyślnyLimit = 1000)
        {
            decimal limit = domyślnyLimit, suma = 0;
            if (ustawienia.Values.ContainsKey(kluczLimitu)) limit = 
                decimal.Parse((string)ustawienia.Values[kluczLimitu]);
            if (ustawienia.Values.ContainsKey(kluczSumy)) suma =
                decimal.Parse((string)ustawienia.Values[kluczSumy]);
            return new AutoSumowanie(limit, suma);
        }     
   
        public static Task ZapiszStanModeluAsync(AutoSumowanie model)
        {
            return Task.Run(
                () =>
                {
                    ZapiszStanModelu(model);
                });
        }

        public static Task<AutoSumowanie> OdczytajStanModeluAsync(decimal domyślnyLimit = 1000)
        {
            return Task<AutoSumowanie>.Run(
                () =>
                {
                    return OdczytajStanModelu(domyślnyLimit);
                });
        }
    }
}
