﻿using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Reflection;
using Windows.UI;
using Windows.UI.Xaml.Media;
using GalaSoft.MvvmLight;
using GalaSoft.MvvmLight.Command;
using Color = Codecamp1.Model.Color;

namespace Codecamp1.ViewModel
{
    public class MainViewModel : ViewModelBase
    {
        private Color _currentSelection;
        private string _helloWorld;

        public MainViewModel()
        {
            HelloWorld = IsInDesignMode ? "Design Mode" : "Runtime";

            var systemColors = typeof (Colors)
                .GetRuntimeProperties()
                .Select(
                    color =>
                        new Color
                        {
                            Brush = new SolidColorBrush((Windows.UI.Color) color.GetValue(null)),
                            Name = color.Name
                        }).ToList();
            Colors = new ObservableCollection<Color>(systemColors);
            CurrentSelection = Colors.First();
            SelectedColors = new ObservableCollection<Color>();
            GroupedColors = new ObservableCollection<IGrouping<char, Color>>(Colors.GroupBy(property => property.Name[0]));
        }

        public ObservableCollection<IGrouping<char, Color>> GroupedColors { get; set; }

        public string HelloWorld
        {
            get { return _helloWorld; }
            set { Set(ref _helloWorld, value); }
        }

        public Color CurrentSelection
        {
            get { return _currentSelection; }
            set { Set(ref _currentSelection, value); }
        }

        public ObservableCollection<Color> Colors { get; set; }
        public ObservableCollection<Color> SelectedColors { get; set; }

        public RelayCommand<Color> AddColoCommand
        {
            get
            {
                return new RelayCommand<Color>(arg =>
                {
                    SelectedColors.Add(arg);
                });
            }
        }
    }
}