﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

using System.Net.Sockets;
using System.Net;
using System.IO;

namespace TCPSerwer
{
    public partial class Form1 : Form
    {
        TcpListener tcpListener;
        TcpClient tcpClient;

        public Form1()
        {
            InitializeComponent();
        }

        private void WłączNasłuchiwanie()
        {
            tcpListener = new TcpListener(IPAddress.Parse(textBox1.Text), (int)numericUpDown1.Value);
            tcpListener.Start();
            tcpListener.BeginAcceptTcpClient(new AsyncCallback(AcceptTcpClientCallback), tcpListener);
        }

        private void AcceptTcpClientCallback(IAsyncResult asyncResult)
        {
            try
            {
                TcpListener tcpListenerAsync = asyncResult.AsyncState as TcpListener;
                tcpClient = tcpListenerAsync.EndAcceptTcpClient(asyncResult);
                NetworkStream ns = tcpClient.GetStream();
                StreamReader sr = new StreamReader(ns);
                string tekst = sr.ReadToEnd();
                if (tekst == null || tekst == "") DodajDoListBox("Nawiązano połączenie");
                else DodajDoListBox("Wiadomość \"" + tekst + "\" z komputera: " + textBox1.Text);
                tcpClient.Close();
                tcpListener.Stop();
                WłączNasłuchiwanie();                
            }
            catch (Exception exc)
            {
                MessageBox.Show("Błąd: " + exc.Message, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        private delegate void DodajDoListBoxCallback(string tekst); 
        private void DodajDoListBox(string tekst)
        {
            if(listBox1.InvokeRequired)
            {
                DodajDoListBoxCallback callback = new DodajDoListBoxCallback(DodajDoListBox);
                this.Invoke(callback, new object[] { tekst });
            }
            else
            {
                listBox1.Items.Add(tekst);
            }
        }

        private void button1_Click(object sender, EventArgs e)
        {
            try
            {
                WłączNasłuchiwanie();
                listBox1.Items.Add("Serwer uruchomiony. Czekam na wiadomość klienta...");
            }
            catch(Exception exc)
            {
                listBox1.Items.Add("Błąd: " + exc.Message);
            }
        }
    }
}
