﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

using System.IO;

namespace FTPKlient
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            textBox2.Text = System.Environment.CurrentDirectory;
        }

        private void button3_Click(object sender, EventArgs e)
        {
            folderBrowserDialog1.SelectedPath = textBox2.Text;
            if (folderBrowserDialog1.ShowDialog() == DialogResult.OK)
            {
                textBox2.Text = folderBrowserDialog1.SelectedPath;
            }
        }

        FtpClient ftpKlient;

        private void button1_Click(object sender, EventArgs e)
        {
            try
            {
                this.Cursor = Cursors.WaitCursor;
                ftpKlient = new FtpClient(textBox1.Text, "anonymous", "jm_spam@wp.pl");
                PrintFtpEntries(ftpKlient.ListDirectory());
                button1.Enabled = false;
                button2.Enabled = true;
                button4.Enabled = true;
                button5.Enabled = true;
            }
            catch(Exception exc)
            {
                MessageBox.Show("Błąd: " + exc.Message + "\nspowodowany przez błąd: " + exc.InnerException.Message, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            finally
            {
                this.Cursor = Cursors.Default;
            }
        }

        private void PrintFtpEntries(List<string> entries)
        {
            listBox2.BeginUpdate();
            listBox2.Items.Clear();
            listBox2.Items.Add("[..]");
            foreach(string entry in entries)
            {
                //listBox2.Items.Add(entry);

                string nazwaPliku = entry.Substring(entry.LastIndexOf(' ') + 1);
                switch(entry[0])
                {
                    case 'd':
                        nazwaPliku = "[" + nazwaPliku + "]";
                        break;
                    case 'l':
                        nazwaPliku = "->" + nazwaPliku;
                        break;
                    default:
                        //zwykłe pliki
                        break;
                }
                listBox2.Items.Add(nazwaPliku);
            }
            listBox2.EndUpdate();
        }

        private void button2_Click(object sender, EventArgs e)
        {
            listBox2.Items.Clear();
            ftpKlient = null;
            button1.Enabled = true;
            button2.Enabled = false;
            button4.Enabled = false;
            button5.Enabled = false;
        }

        private void button4_Click(object sender, EventArgs e)
        {
            try
            {
                this.Cursor = Cursors.WaitCursor;
                PrintFtpEntries(ftpKlient.ListParentDirectory());
                textBox1.Text = ftpKlient.FtpDirectory;                
            }
            catch(Exception exc)
            {
                MessageBox.Show("Błąd: " + exc.Message + "\nspowodowany przez błąd: " + exc.InnerException.Message, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            finally
            {
                this.Cursor = Cursors.Default;
            }
        }

        private void listBox2_DoubleClick(object sender, EventArgs e)
        {
            try
            {
                this.Cursor = Cursors.WaitCursor;

                int indeks = listBox2.SelectedIndex;
                string nazwa = listBox2.SelectedItem.ToString();
                if (indeks < 0) return;
                if (indeks == 0)
                {
                    button4_Click(null, null);
                    return;
                }
                else
                {
                    if (nazwa[0] != '[') return;
                    nazwa = nazwa.Substring(1, nazwa.Length - 2);
                    PrintFtpEntries(ftpKlient.ListSubDirectory(nazwa));
                }
                textBox1.Text = ftpKlient.FtpDirectory;
            }
            catch (Exception exc)
            {
                MessageBox.Show("Błąd: " + exc.Message + "\nspowodowany przez błąd: " + exc.InnerException.Message, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            finally
            {
                this.Cursor = Cursors.Default;
            }
        }

        private void button5_Click(object sender, EventArgs e)
        {
            try
            {
                this.Cursor = Cursors.WaitCursor;

                int indeks = listBox2.SelectedIndex;
                string nazwa = listBox2.SelectedItem.ToString();
                if (indeks < 0) return;
                if (nazwa.Contains('[')) return;
                if (nazwa.Contains("->"))
                {
                    MessageBox.Show("Linki nie są wspierane");
                    return;
                }

                string localFileName = System.IO.Path.Combine(textBox2.Text, nazwa);
                string remoteFileName = ftpKlient.FtpDirectory + "/" + nazwa;
                ftpKlient.DownloadFile(remoteFileName, localFileName);
                MessageBox.Show("Plik " + remoteFileName + " został zapisany w " + localFileName, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Information);
            }
            catch(Exception exc)
            {
                MessageBox.Show("Błąd pobierania pliku: " + exc.Message, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
            finally
            {
                this.Cursor = Cursors.Default;
            }
        }

    }
}
