﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

using System.IO;

namespace KontrolkaDemo
{
    public partial class FileListBox : UserControl
    {
        #region Pola prywatne
        //wewntrzne
        private string[] listaKatalogów = null;
        private string[] listaPlików = null;
        private string[] listaDysków = null;
        private bool pokazujDwieKropki = true;
        //konfiguracja
        private string ścieżkaKatalogu = null;
        private bool uwzględnijKatalogi = true;
        private bool uwzględnijPliki = true;
        private bool uwzględnijDyski = true;
        private bool uwzględnijKatalogNadrzędny = true;
        private string filtr = null;
        private bool możliwośćZmianyKatalogu = true;
        #endregion

        #region Własności
        [
            Category("Katalog"),
            Description("Własność ŚcieżkaKatalogu wskazuje na katalog prezentowany w kontrolce")
        ]
        public string ŚcieżkaKatalogu
        {
            set
            {
                this.ścieżkaKatalogu = value;
                PobierzZawartośćKatalogu();
                fileSystemWatcher1.Path = ścieżkaKatalogu;
            }
            get
            {
                return this.ścieżkaKatalogu;
            }
        }

        [Category("Katalog")]
        public string Filtr
        {
            set
            {
                this.filtr = value;
                PobierzZawartośćKatalogu();
            }
            get
            {
                return this.filtr;
            }
        }

        [Category("Katalog")]
        public bool KatalogiWidoczne
        {
            set
            {
                this.uwzględnijKatalogi = value;
                PobierzZawartośćKatalogu();
            }
            get
            {
                return this.uwzględnijKatalogi;
            }
        }

        [Category("Katalog")]
        public string ŚcieżkaZaznaczonegoElementu
        {
            get
            {
                int przesuniecie = (pokazujDwieKropki && uwzględnijKatalogi) ? 1 : 0;
                //przesuniecie += 2;
                int numer = listBox1.SelectedIndex - przesuniecie;
                int poczatekPlikow = uwzględnijKatalogi ? listaKatalogów.Count() : 0;
                int poczatekDyskow = poczatekPlikow + (uwzględnijPliki ? listaPlików.Count() : 0);

                string pełnaŚcieżka = null;
                if (numer == -1 && przesuniecie == 1) pełnaŚcieżka = ścieżkaKatalogu + "\\..";
                if (numer >= 0 && numer < poczatekPlikow) pełnaŚcieżka = listaKatalogów[numer];
                if (numer >= poczatekPlikow && numer < poczatekDyskow) pełnaŚcieżka = listaPlików[numer - poczatekPlikow];
                if (numer >= poczatekDyskow) pełnaŚcieżka = listaDysków[numer - poczatekDyskow];
                if (pełnaŚcieżka == null) return "";

                return Path.GetFullPath(pełnaŚcieżka);
            }
        }
        #endregion

        public FileListBox()
        {
            InitializeComponent();
            ścieżkaKatalogu = System.Environment.GetFolderPath(Environment.SpecialFolder.Personal);
            PobierzZawartośćKatalogu();
            fileSystemWatcher1.Path = ścieżkaKatalogu;
        }

        #region Metody prywatne
        private void PobierzZawartośćKatalogu()
        {
            if (ścieżkaKatalogu == null) ścieżkaKatalogu = Directory.GetCurrentDirectory();
            ścieżkaKatalogu = Path.GetFullPath(ścieżkaKatalogu);

            pokazujDwieKropki = (ścieżkaKatalogu != Path.GetPathRoot(ścieżkaKatalogu)) && uwzględnijKatalogNadrzędny;

            if (!Directory.Exists(ścieżkaKatalogu)) throw new DirectoryNotFoundException("Katalog " + ścieżkaKatalogu + " nie istnieje");

            listBox1.Items.Clear();
            //listBox1.Items.Add("TEST: " + ścieżkaKatalogu);
            //listBox1.Items.Add("TEST: " + Path.GetPathRoot(ścieżkaKatalogu));            

            if(uwzględnijKatalogi)
            {
                if (pokazujDwieKropki) listBox1.Items.Add("[..]");
                listaKatalogów = Directory.GetDirectories(ścieżkaKatalogu);
                Array.Sort(listaKatalogów);
                //listBox1.Items.AddRange(listaKatalogów);
                foreach (string katalog in listaKatalogów) 
                    listBox1.Items.Add("[" + Path.GetFileName(katalog) + "]");
            }
            if(uwzględnijPliki)
            {
                if (filtr != null) listaPlików = Directory.GetFiles(ścieżkaKatalogu, filtr);
                else listaPlików = Directory.GetFiles(ścieżkaKatalogu);
                Array.Sort(listaPlików);
                //listBox1.Items.AddRange(listaPlików);
                foreach (string plik in listaPlików) 
                    listBox1.Items.Add(Path.GetFileName(plik));
            }
            if(uwzględnijDyski)
            {
                listaDysków = Directory.GetLogicalDrives();
                //listBox1.Items.AddRange(listaDysków);
                foreach (string dysk in listaDysków)
                    listBox1.Items.Add("<" + dysk.Substring(0, 2) + ">");
            }

            OnZmianaZaznaczonegoElementu(this, new EventArgs());
        }
        #endregion

        private void listBox1_DoubleClick(object sender, EventArgs e)
        {
            if (!możliwośćZmianyKatalogu) return;

            int przesuniecie = (pokazujDwieKropki && uwzględnijKatalogi) ? 1 : 0;
            //przesuniecie += 2;
            int numer = listBox1.SelectedIndex - przesuniecie;
            int poczatekPlikow = uwzględnijKatalogi ? listaKatalogów.Count() : 0;
            int poczatekDyskow = poczatekPlikow + (uwzględnijPliki ? listaPlików.Count() : 0);

            string nowaŚcieżkaKatalogu = null;
            if (numer == -1) nowaŚcieżkaKatalogu = ścieżkaKatalogu + "\\..";
            if (numer >= 0 && numer < poczatekPlikow) nowaŚcieżkaKatalogu = listaKatalogów[numer]; //katalog
            if (numer >= poczatekDyskow) nowaŚcieżkaKatalogu = listaDysków[numer - poczatekDyskow]; //dysk
            if (nowaŚcieżkaKatalogu != null && Directory.Exists(nowaŚcieżkaKatalogu))
            {
                ścieżkaKatalogu = nowaŚcieżkaKatalogu;
                PobierzZawartośćKatalogu();
                fileSystemWatcher1.Path = ścieżkaKatalogu;
            }
        }

        private void listBox1_Click(object sender, EventArgs e)
        {
            this.OnClick(e);
        }

        #region Zdarzenie
        public delegate void ZmianaZaznaczonegoElementuEventHandler(object sender, EventArgs e);

        [Category("Katalog")]
        public event ZmianaZaznaczonegoElementuEventHandler ZmianaZaznaczonegoElementu;

        protected virtual void OnZmianaZaznaczonegoElementu(object sender,EventArgs e)
        {
            if (ZmianaZaznaczonegoElementu != null) ZmianaZaznaczonegoElementu(sender, e);
        }
        #endregion

        private void listBox1_SelectedIndexChanged(object sender, EventArgs e)
        {
            OnZmianaZaznaczonegoElementu(sender, e);
        }

        public override void Refresh()
        {
            base.Refresh();
            PobierzZawartośćKatalogu();
        }

        private void fileSystemWatcher1_Changed(object sender, FileSystemEventArgs e)
        {
            PobierzZawartośćKatalogu();
        }

        private void fileSystemWatcher1_Renamed(object sender, RenamedEventArgs e)
        {
            PobierzZawartośćKatalogu();    
        }
    }
}
