﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

using System.IO;

namespace KontrolkaDemo
{
    public partial class FileListBox : UserControl
    {
        #region Pola prywatne
        //wewntrzne
        private string[] listaKatalogów = null;
        private string[] listaPlików = null;
        private string[] listaDysków = null;
        private bool pokazujDwieKropki = true;
        //konfiguracja
        private string ścieżkaKatalogu = null;
        private bool uwzględnijKatalogi = true;
        private bool uwzględnijPliki = true;
        private bool uwzględnijDyski = true;
        private bool uwzględnijKatalogNadrzędny = true;
        private string filtr = null;
        #endregion

        public FileListBox()
        {
            InitializeComponent();
            PobierzZawartośćKatalogu();
        }

        #region Metody prywatne
        private void PobierzZawartośćKatalogu()
        {
            if (ścieżkaKatalogu == null) ścieżkaKatalogu = Directory.GetCurrentDirectory();

            pokazujDwieKropki = (ścieżkaKatalogu != Path.GetPathRoot(ścieżkaKatalogu)) && uwzględnijKatalogNadrzędny;

            if (!Directory.Exists(ścieżkaKatalogu)) throw new DirectoryNotFoundException("Katalog " + ścieżkaKatalogu + " nie istnieje");

            listBox1.Items.Clear();

            if(uwzględnijKatalogi)
            {
                if (pokazujDwieKropki) listBox1.Items.Add("[..]");
                listaKatalogów = Directory.GetDirectories(ścieżkaKatalogu);
                Array.Sort(listaKatalogów);
                listBox1.Items.AddRange(listaKatalogów);
            }
            if(uwzględnijPliki)
            {
                listaPlików = Directory.GetFiles(ścieżkaKatalogu);
                Array.Sort(listaPlików);
                listBox1.Items.AddRange(listaPlików);
            }
            if(uwzględnijDyski)
            {
                listaDysków = Directory.GetLogicalDrives();
                listBox1.Items.AddRange(listaDysków);
            }
        }
        #endregion
    }
}
