﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace AplikacjaZBazaDanych
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            osobyBindingSource.DataSource = bazaDanych.Osobies;
        }

        BazaDanychDataContext bazaDanych = new BazaDanychDataContext();

        private void button1_Click(object sender, EventArgs e)
        {
            var osoby = bazaDanych.Osobies;
            var rozmowy = bazaDanych.Rozmowies;

            /*
            var listaDlugichRozmow = from osoba in osoby
                                     join rozmowa in rozmowy on osoba.Id equals rozmowa.IdOsoby
                                     where rozmowa.CzasTrwania > 100
                                     select new { osoba.Wiek, rozmowa.CzasTrwania };

            string s = "Lista długich rozmów:\n";
            foreach (var element in listaDlugichRozmow) s += "" + element.Wiek + " " + element.CzasTrwania + "\n";
            MessageBox.Show(s);
            */

            IEnumerable<string> listaDlugichRozmow = from osoba in osoby
                                                     join rozmowa in rozmowy on osoba.Id equals rozmowa.IdOsoby
                                                     where rozmowa.CzasTrwania > 100
                                                     select osoba.Imię + " " + osoba.Nazwisko + ", " + rozmowa.CzasTrwania + "s, rozmówca: " + rozmowa.Rozmówca;

            string s = "Lista długich rozmów:\n";
            foreach (string element in listaDlugichRozmow) s += element + "\n";
            MessageBox.Show(s);

        }

        private void button2_Click(object sender, EventArgs e)
        {
            Osoby osoba = bazaDanych.Osobies.First();
            IEnumerable<Rozmowy> rozmowyOsoby = osoba.Rozmowies;
            
            string s = "Lista rozmów osoby "+osoba.Imię+" "+osoba.Nazwisko+"\n";
            foreach (Rozmowy rozmowa in rozmowyOsoby) s += rozmowa.Rozmówca + "\n";
            MessageBox.Show(s);
        }

        private void button3_Click(object sender, EventArgs e)
        {
            IEnumerable<PobierzListeOsobPelnoletnichResult> listaOsóbPełnoletnich = bazaDanych.PobierzListeOsobPelnoletnich();            
            string s = "Lista osób przez zmianą wieku:\n";
            foreach (var osoba in listaOsóbPełnoletnich) s += osoba.Imię + " " + osoba.Nazwisko + " (" + osoba.Wiek + ")\n";
            MessageBox.Show(s);

            bazaDanych.AktualizujWiek();

            listaOsóbPełnoletnich = bazaDanych.PobierzListeOsobPelnoletnich();
            s = "Lista osób po zmianie wieku:\n";
            foreach (var osoba in listaOsóbPełnoletnich) s += osoba.Imię + " " + osoba.Nazwisko + " (" + osoba.Wiek + ")\n";
            MessageBox.Show(s);
        }

        private void button4_Click(object sender, EventArgs e)
        {
            IEnumerable<OsobyPelnoletnie> osobyPelnoletnie = bazaDanych.OsobyPelnoletnies;
            string s = "Lista osób pełnoletnich z widoku:\n";
            foreach (OsobyPelnoletnie osoba in osobyPelnoletnie) s += osoba.Imię + " " + osoba.Nazwisko + " (" + osoba.Wiek + ")\n";
            MessageBox.Show(s);
        }
    }
}
