﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

using System.Data.Linq.Mapping;
using System.Data.Linq;

namespace AplikacjaZBazaDanych
{
    public partial class Form1 : Form
    {
        [Table(Name = "Osoby")]
        public class Osoba
        {
            [Column(Name = "Id", IsPrimaryKey = true, CanBeNull = false)]
            public int Id;
            [Column(CanBeNull = false)]
            public string Imię;
            [Column(CanBeNull = false)]
            public string Nazwisko;
            [Column(CanBeNull = false)]
            public string Email;
            [Column(CanBeNull = true)]
            public int? NumerTelefonu;
            [Column(CanBeNull = false)]
            public int Wiek;
        }


        public Form1()
        {
            InitializeComponent();
            odświeżWidokTabeli(null, null);
            button6_Click(null,null);
        }

        //const string connectionString = @"Data Source=(LocalDB)\v11.0;AttachDbFilename='c:\Users\pk\Documents\Visual Studio 2013\Projects\AplikacjaZBazaDanych\AplikacjaZBazaDanych\BazaDanych.mdf';Integrated Security=True";
        const string connectionString = @"Data Source=(LocalDB)\v11.0;AttachDbFilename='|DataDirectory|BazaDanych.mdf';Integrated Security=True";
        static DataContext bazaDanych = new DataContext(connectionString);
        static Table<Osoba> osoby = bazaDanych.GetTable<Osoba>();

        private void button1_Click(object sender, EventArgs e)
        {
            //pobieranie kolekcji  
            var listaOsóbPełnoletnich = from o in osoby
                                        where o.Wiek >= 18
                                        orderby o.Nazwisko
                                        select o;

            //wyświetlanie
            string s = "Lista osób pełnoletnich:\n";
            foreach (Osoba o in listaOsóbPełnoletnich) s += o.Imię + " " + o.Nazwisko + " (" + o.Wiek.ToString() + ")\n";
            MessageBox.Show(s);
        }

        private void button2_Click(object sender, EventArgs e)
        {
            //pobieranie kolekcji
            var listaOsóbDoZmiany = from osoba in osoby
                                    where (osoba.Wiek < 18 || !osoba.Imię.EndsWith("a"))
                                    select osoba;

            //wyświetlanie pobranej kolekcji
            string s = "Lista osób do zmiany:\n";
            foreach (Osoba o in listaOsóbDoZmiany) s += o.Imię + " " + o.Nazwisko + " (" + o.Wiek.ToString() + ")\n";
            MessageBox.Show(s);

            //modyfikowanie kolekcji
            foreach (Osoba o in listaOsóbDoZmiany) o.Wiek++;

            //wyświetlanie pobranej kolekcji
            s = "Lista osób do zmiany:\n";
            foreach (Osoba o in listaOsóbDoZmiany) s += o.Imię + " " + o.Nazwisko + " (" + o.Wiek.ToString() + ")\n";
            MessageBox.Show(s);

            //zapisywanie zmian
            bazaDanych.SubmitChanges();
        }

        private void odświeżWidokTabeli(object sender, EventArgs e)
        {
            var pelneDane = from o in osoby
                            select new { o.Id, o.Imię, o.Nazwisko, o.Email, o.NumerTelefonu, o.Wiek };                            
                            //select new Osoba() { Id = o.Id, Imię = o.Imię, Nazwisko = o.Nazwisko, Email = o.Email, NumerTelefonu = o.NumerTelefonu, Wiek = o.Wiek };
                            //select o;
            dataGridView1.DataSource = pelneDane.ToList();
        }

        private void button4_Click(object sender, EventArgs e)
        {
            //dodanie nowej osoby do tabeli
            int noweId = osoby.Max(o => o.Id) + 1;
            MessageBox.Show("Nowe ID: " + noweId);

            //nowy rekord
            //Osoba kalina = new Osoba { Id = noweId, Imię = "Kalina", Nazwisko = "Blek", Email = "", NumerTelefonu = null, Wiek = 2 };
            Osoba nowaOsoba = new Osoba { Id = noweId, Imię = "Jan", Nazwisko = "Kowalski", Email = "jk@firma.pl", NumerTelefonu = null, Wiek = 56 };
            osoby.InsertOnSubmit(nowaOsoba);

            //zapisywanie zmian
            bazaDanych.SubmitChanges();

            //wyświetl tabelę
            odświeżWidokTabeli(null, null);
        }

        private void button5_Click(object sender, EventArgs e)
        {
            //wybieranie rekordów do usuniecia
            IEnumerable<Osoba> doSkasowania = from osoba in osoby
                                              where osoba.Imię == "Jan"
                                              select osoba;
            
            //zaznaczanie do usuniecia
            osoby.DeleteAllOnSubmit(doSkasowania);

            //usuwanie
            bazaDanych.SubmitChanges();

            //wyświetl tabelę
            odświeżWidokTabeli(null, null);
        }

        Form2 form2 = new Form2();
        Form3 form3 = new Form3();

        private void button6_Click(object sender, EventArgs e)
        {
            
            if (form2 != null) form2.Visible=!form2.Visible;
            if (form3 != null) form3.Visible=!form3.Visible;
        }
    }
}
