﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

using System.Xml.Linq;

namespace XML_Drzewo
{
    public partial class Form1 : Form
    {
        void DodajElementDoWezla(XElement elementXml, TreeNode wezełDrzewa, int poziom)
        {
            poziom++;            

            IEnumerable<XNode> węzły = elementXml.Nodes();
            foreach (XNode węzeł in węzły)
            {
                if (węzeł.NodeType == System.Xml.XmlNodeType.Element)
                {
                    XElement element = węzeł as XElement;
                    string opis = element.Name.LocalName;
                    if (!element.HasElements) opis += " (" + element.Value + ")";
                    TreeNode nowyWęzeł = new TreeNode(opis);
                    wezełDrzewa.Nodes.Add(nowyWęzeł);
                    DodajElementDoWezla(element, nowyWęzeł, poziom);
                }
            }
        }

        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            try
            {
                //string uri = @"Ustawienia.xml";
                string uri = @"http://www.nbp.pl/kursy/xml/LastC.xml";

                XDocument xml = XDocument.Load(uri);
                Text = "Aktualne kursy walut NBP - tabela: " + xml.Root.Element("numer_tabeli").Value;

                treeView1.BeginUpdate();
                treeView1.Nodes.Clear();

                TreeNode węzełGłówny = new TreeNode(xml.Root.Name.LocalName);
                DodajElementDoWezla(xml.Root, węzełGłówny, 0);
                treeView1.Nodes.Add(węzełGłówny);

                //treeView1.ExpandAll();                  
                węzełGłówny.Expand();
                treeView1.EndUpdate();                
            }
            catch(Exception exc)
            {
                MessageBox.Show("Błąd: " + exc.Message);
            }
        }
    }
}
