﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace AplikacjaZBazaDanych
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();            
        }

        bool daneZmienione = false;

        private void Form1_Load(object sender, EventArgs e)
        {
            // TODO: This line of code loads data into the 'bazaDanychDataSet.Osoby' table. You can move, or remove it, as needed.
            this.osobyTableAdapter.Fill(this.bazaDanychDataSet.Osoby); //z dataset do widoku

            daneZmienione = false;
        }

        private void dataGridView1_CellValueChanged(object sender, DataGridViewCellEventArgs e)
        {
            daneZmienione = true;
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (!daneZmienione) return;

            DialogResult dr = MessageBox.Show(
                "Czy zapisać zmiany do bazy danych?", 
                this.Text, 
                MessageBoxButtons.YesNoCancel, 
                MessageBoxIcon.Question, 
                MessageBoxDefaultButton.Button3);

            switch (dr)
            {
                case DialogResult.Yes:
                    this.Validate();
                    this.osobyBindingSource.EndEdit();
                    this.osobyTableAdapter.Update(bazaDanychDataSet.Osoby); //z dataset do bazy danych
                    MessageBox.Show(
                        "Dane zostały zapisane", 
                        this.Text, 
                        MessageBoxButtons.OK, 
                        MessageBoxIcon.Information);
                    break;
                case DialogResult.No:
                    //nic nie robimy
                    break;
                case DialogResult.Cancel:
                    e.Cancel = true;
                    break;
            };
        }

        private void Form1_Shown(object sender, EventArgs e)
        {
            new Formularz().Show();
            new Formularz2().Show();
        }
    }
}
