﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

using System.IO;

namespace Notatnik.NET
{
    public partial class Form1 : Form
    {
        private string ścieżkaPliku = "";

        public Form1()
        {
            InitializeComponent();
        }

        private void zakończToolStripMenuItem_Click(object sender, EventArgs e)
        {
            //zakończToolStripMenuItem.Text = "Inny";
            this.Close();
        }

        private void nowyToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.Text = "";
        }


        #region "Obsługa plików"
        static bool zapiszDoPliku(string ścieżkaPliku, string[] tekst)
        {
            try
            {
                using (StreamWriter sw = new StreamWriter(ścieżkaPliku))
                {
                    foreach (string wiersz in tekst)
                    {
                        sw.WriteLine(wiersz);
                    }
                    //sw.Close();
                }
                return true;
            }
            catch (Exception exc)
            {
                MessageBox.Show("Błąd zapisu pliku: " + exc.Message, "Błąd", MessageBoxButtons.OK, MessageBoxIcon.Error);
                return false;
            }
        }

        static string[] odczytajZPliku(string ścieżkaPliku)
        {
            try
            {
                List<string> wiersze = new List<string>();
                using (StreamReader sr = new StreamReader(ścieżkaPliku))
                {                    
                    string wiersz;
                    while ((wiersz = sr.ReadLine()) != null)
                    {
                        wiersze.Add(wiersz);
                    }
                }
                return wiersze.ToArray();
            }
            catch (Exception exc)
            {
                MessageBox.Show("Błąd odczytu pliku: " + exc.Message, "Błąd", MessageBoxButtons.OK, MessageBoxIcon.Error);
                return null;
            }
        }
        #endregion

        private void zapiszJakoToolStripMenuItem_Click(object sender, EventArgs e)
        {
            //zapiszDoPliku("C:\\Temp\\plik.txt", textBox1.Lines);
            //zapiszDoPliku(@"C:\Temp\plik.txt", textBox1.Lines);

            if (File.Exists(ścieżkaPliku))
            {                
                saveFileDialog1.InitialDirectory = Path.GetDirectoryName(ścieżkaPliku);
                saveFileDialog1.FileName = Path.GetFileName(ścieżkaPliku);
            }

            DialogResult dr = saveFileDialog1.ShowDialog();
            if (dr == DialogResult.OK)
            {
                zapiszDoPliku(saveFileDialog1.FileName, textBox1.Lines);
                ścieżkaPliku = saveFileDialog1.FileName;
            }
        }

        private void otwórzToolStripMenuItem_Click(object sender, EventArgs e)
        {
            //textBox1.Lines = odczytajZPliku("C:\\Temp\\plik.txt");            

            if (File.Exists(ścieżkaPliku))
            {
                openFileDialog1.InitialDirectory = Path.GetDirectoryName(ścieżkaPliku);
                openFileDialog1.FileName = Path.GetFileName(ścieżkaPliku);
            }
            
            DialogResult dr = openFileDialog1.ShowDialog();
            if (dr == DialogResult.OK)
            {
                textBox1.Lines = odczytajZPliku(openFileDialog1.FileName);
                ścieżkaPliku = openFileDialog1.FileName;
            }            
        }

        private void cofnijToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.Undo();            
        }

        private void wytnijToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.Cut();                        
        }

        private void kopiujToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.Copy();
        }

        private void wklejToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.Paste();
        }

        private void usuńToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.SelectedText = "";
        }

        private void zaznaczWszystkoToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.SelectAll();
        }

        private void godzinadataToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.SelectedText = DateTime.Now.ToString();
        }

        private void pasekStanyToolStripMenuItem_Click(object sender, EventArgs e)
        {
            pasekStanyToolStripMenuItem.Checked = !pasekStanyToolStripMenuItem.Checked;
            statusStrip1.Visible = pasekStanyToolStripMenuItem.Checked;
        }

        private void pasekNarzędziToolStripMenuItem_Click(object sender, EventArgs e)
        {
            pasekNarzędziToolStripMenuItem.Checked = !pasekNarzędziToolStripMenuItem.Checked;
            toolStrip1.Visible = pasekNarzędziToolStripMenuItem.Checked;
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            pasekStanyToolStripMenuItem.Checked = statusStrip1.Visible;
            pasekNarzędziToolStripMenuItem.Checked = toolStrip1.Visible;
        }

        private void czcionkaToolStripMenuItem_Click(object sender, EventArgs e)
        {
            fontDialog1.Font = textBox1.Font;
            fontDialog1.Color = textBox1.ForeColor;
            DialogResult dr = fontDialog1.ShowDialog();
            if (dr == DialogResult.OK)
            {
                textBox1.Font = fontDialog1.Font;
                textBox1.ForeColor = fontDialog1.Color;
            }
        }

        private void kolorTłaToolStripMenuItem_Click(object sender, EventArgs e)
        {
            colorDialog1.Color = textBox1.BackColor;
            DialogResult dr = colorDialog1.ShowDialog();
            if (dr == DialogResult.OK)
            {
                textBox1.BackColor = colorDialog1.Color;
            }
        }

        private StringReader sr = null;

        /*
        //wersja bez podziału na linie
        private void printDocument1_PrintPage(object sender, System.Drawing.Printing.PrintPageEventArgs e)
        {
            Font czcionka = textBox1.Font;
            SolidBrush pędzel = new SolidBrush(textBox1.ForeColor);
            int wysokośćWiersza = (int)czcionka.GetHeight(e.Graphics);
            int liczbaLinii = e.MarginBounds.Height / wysokośćWiersza; //na jednej stronie

            if (sr == null) //pierwsza strona
                sr = new StringReader(textBox1.Text);

            e.HasMorePages = true;

            for (int i = 0; i < liczbaLinii; i++)
            {
                string wiersz = sr.ReadLine();
                if (wiersz == null)
                {
                    e.HasMorePages = false;
                    sr = null;
                    break;
                }
                e.Graphics.DrawString(
                    wiersz,
                    czcionka,
                    //Brushes.Black,
                    pędzel,
                    e.MarginBounds.Left,
                    e.MarginBounds.Top + i * wysokośćWiersza);
            }
        }
        */

        /*
        //wersja z podziałem na linie, ale bez uwzględnia wyrazów
        private void printDocument1_PrintPage(object sender, System.Drawing.Printing.PrintPageEventArgs e)
        {
            Font czcionka = textBox1.Font;
            SolidBrush pędzel = new SolidBrush(textBox1.ForeColor);
            int wysokośćWiersza = (int)czcionka.GetHeight(e.Graphics);
            int liczbaLinii = e.MarginBounds.Height / wysokośćWiersza; //na jednej stronie

            if (sr == null) //pierwsza strona
            {
                string tekst = "";
                foreach (string wiersz in textBox1.Lines)
                {
                    float szerokość = e.Graphics.MeasureString(wiersz, czcionka).Width;
                    if (szerokość < e.MarginBounds.Width)
                    {
                        tekst += wiersz + "\n";
                    }
                    else
                    {
                        float średniaSzerokośćLitery = szerokość / wiersz.Length;
                        int liczbaLiterWWierszu = (int)(e.MarginBounds.Width / średniaSzerokośćLitery);
                        int liczbaLiniiZAkapitu = wiersz.Length / liczbaLiterWWierszu;
                        for (int i = 0; i < liczbaLiniiZAkapitu; ++i)
                        {
                            tekst += wiersz.Substring(i * liczbaLiterWWierszu, liczbaLiterWWierszu) + "\n";
                        }
                        tekst += wiersz.Substring(liczbaLiniiZAkapitu * liczbaLiterWWierszu) + "\n";
                    }
                }
                sr = new StringReader(tekst);
            }

            e.HasMorePages = true;

            for (int i = 0; i < liczbaLinii; i++)
            {
                string wiersz = sr.ReadLine();
                if (wiersz == null)
                {
                    e.HasMorePages = false;
                    sr = null;
                    break;
                }
                e.Graphics.DrawString(
                    wiersz,
                    czcionka,
                    //Brushes.Black,
                    pędzel,
                    e.MarginBounds.Left,
                    e.MarginBounds.Top + i * wysokośćWiersza);
            }
        }
        */

        private void printDocument1_PrintPage(object sender, System.Drawing.Printing.PrintPageEventArgs e)
        {
            Font czcionka = textBox1.Font;
            SolidBrush pędzel = new SolidBrush(textBox1.ForeColor);
            int wysokośćWiersza = (int)czcionka.GetHeight(e.Graphics);
            int liczbaLinii = e.MarginBounds.Height / wysokośćWiersza; //na jednej stronie

            if (sr == null) //pierwsza strona
            {
                string tekst = "";
                foreach (string wiersz in textBox1.Lines)
                {
                    float szerokość = e.Graphics.MeasureString(wiersz, czcionka).Width;
                    if (szerokość < e.MarginBounds.Width)
                    {
                        tekst += wiersz + "\n";
                    }
                    else
                    {
                        float średniaSzerokośćLitery = szerokość / wiersz.Length;
                        int liczbaLiterWWierszu = (int)(e.MarginBounds.Width / średniaSzerokośćLitery);
                        
                        string skracanyWiersz = wiersz;
                        do
                        {
                            int ostatniaSpacja = skracanyWiersz.Substring(0, liczbaLiterWWierszu).LastIndexOf(' '); //w wierszu, a nie w akapicie
                            int liczbaLiter = (ostatniaSpacja!=-1)?Math.Min(ostatniaSpacja,liczbaLiterWWierszu):liczbaLiterWWierszu;
                            tekst += skracanyWiersz.Substring(0, liczbaLiter).Trim(' ') + "\n";
                            skracanyWiersz = skracanyWiersz.Substring(liczbaLiter).TrimStart(' ');
                        } while (skracanyWiersz.Length > liczbaLiterWWierszu);
                        tekst += skracanyWiersz + "\n";
                    }
                }
                sr = new StringReader(tekst);
            }

            e.HasMorePages = true;
            
            for (int i = 0; i < liczbaLinii; i++)
            {
                string wiersz = sr.ReadLine();
                if (wiersz == null)
                {
                    e.HasMorePages = false;
                    sr = null;
                    break;
                }
                e.Graphics.DrawString(
                    wiersz,
                    czcionka,
                    //Brushes.Black,
                    pędzel,
                    e.MarginBounds.Left,
                    e.MarginBounds.Top + i * wysokośćWiersza);
            }
        }

        private void toolStripMenuItem5_Click(object sender, EventArgs e)
        {
            
            DialogResult dr = printDialog1.ShowDialog();
            if (dr == DialogResult.OK)
            {
                /*
                //to przeniesione do backgroundWorker1_DoWork
                printDocument1.DocumentName = "Notatnik.NET - " + Path.GetFileName(ścieżkaPliku);
                printDocument1.Print();
                */
                backgroundWorker1.RunWorkerAsync();
            }
        }

        private void toolStripMenuItem4_Click(object sender, EventArgs e)
        {
            pageSetupDialog1.ShowDialog();
        }

        private void toolStripMenuItem7_Click(object sender, EventArgs e)
        {
            printPreviewDialog1.ShowDialog();
        }

        private void backgroundWorker1_DoWork(object sender, DoWorkEventArgs e)
        {
            printDocument1.DocumentName = "Notatnik.NET - " + Path.GetFileName(ścieżkaPliku);
            printDocument1.Print();
        }
    }
}
