﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

using System.IO;

namespace Notatnik.NET
{
    public partial class Form1 : Form
    {
        private string ścieżkaPliku = "";

        public Form1()
        {
            InitializeComponent();
        }

        private void zakończToolStripMenuItem_Click(object sender, EventArgs e)
        {
            //zakończToolStripMenuItem.Text = "Inny";
            this.Close();
        }

        private void nowyToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.Text = "";
        }


        #region "Obsługa plików"
        static bool zapiszDoPliku(string ścieżkaPliku, string[] tekst)
        {
            try
            {
                using (StreamWriter sw = new StreamWriter(ścieżkaPliku))
                {
                    foreach (string wiersz in tekst)
                    {
                        sw.WriteLine(wiersz);
                    }
                    //sw.Close();
                }
                return true;
            }
            catch (Exception exc)
            {
                MessageBox.Show("Błąd zapisu pliku: " + exc.Message, "Błąd", MessageBoxButtons.OK, MessageBoxIcon.Error);
                return false;
            }
        }

        static string[] odczytajZPliku(string ścieżkaPliku)
        {
            try
            {
                List<string> wiersze = new List<string>();
                using (StreamReader sr = new StreamReader(ścieżkaPliku))
                {                    
                    string wiersz;
                    while ((wiersz = sr.ReadLine()) != null)
                    {
                        wiersze.Add(wiersz);
                    }
                }
                return wiersze.ToArray();
            }
            catch (Exception exc)
            {
                MessageBox.Show("Błąd odczytu pliku: " + exc.Message, "Błąd", MessageBoxButtons.OK, MessageBoxIcon.Error);
                return null;
            }
        }
        #endregion

        private void zapiszJakoToolStripMenuItem_Click(object sender, EventArgs e)
        {
            //zapiszDoPliku("C:\\Temp\\plik.txt", textBox1.Lines);
            //zapiszDoPliku(@"C:\Temp\plik.txt", textBox1.Lines);

            if (File.Exists(ścieżkaPliku))
            {                
                saveFileDialog1.InitialDirectory = Path.GetDirectoryName(ścieżkaPliku);
                saveFileDialog1.FileName = Path.GetFileName(ścieżkaPliku);
            }

            DialogResult dr = saveFileDialog1.ShowDialog();
            if (dr == DialogResult.OK)
            {
                zapiszDoPliku(saveFileDialog1.FileName, textBox1.Lines);
                ścieżkaPliku = saveFileDialog1.FileName;
            }
        }

        private void otwórzToolStripMenuItem_Click(object sender, EventArgs e)
        {
            //textBox1.Lines = odczytajZPliku("C:\\Temp\\plik.txt");            

            if (File.Exists(ścieżkaPliku))
            {
                openFileDialog1.InitialDirectory = Path.GetDirectoryName(ścieżkaPliku);
                openFileDialog1.FileName = Path.GetFileName(ścieżkaPliku);
            }
            
            DialogResult dr = openFileDialog1.ShowDialog();
            if (dr == DialogResult.OK)
            {
                textBox1.Lines = odczytajZPliku(openFileDialog1.FileName);
                ścieżkaPliku = openFileDialog1.FileName;
            }            
        }

        private void cofnijToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.Undo();            
        }

        private void wytnijToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.Cut();                        
        }

        private void kopiujToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.Copy();
        }

        private void wklejToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.Paste();
        }

        private void usuńToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.SelectedText = "";
        }

        private void zaznaczWszystkoToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.SelectAll();
        }

        private void godzinadataToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.SelectedText = DateTime.Now.ToString();
        }

        private void pasekStanyToolStripMenuItem_Click(object sender, EventArgs e)
        {
            pasekStanyToolStripMenuItem.Checked = !pasekStanyToolStripMenuItem.Checked;
            statusStrip1.Visible = pasekStanyToolStripMenuItem.Checked;
        }

        private void pasekNarzędziToolStripMenuItem_Click(object sender, EventArgs e)
        {
            pasekNarzędziToolStripMenuItem.Checked = !pasekNarzędziToolStripMenuItem.Checked;
            toolStrip1.Visible = pasekNarzędziToolStripMenuItem.Checked;
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            pasekStanyToolStripMenuItem.Checked = statusStrip1.Visible;
            pasekNarzędziToolStripMenuItem.Checked = toolStrip1.Visible;
        }
    }
}
