﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Navigation;
using Microsoft.Phone.Controls;
using Microsoft.Phone.Shell;
using Notatnik.Resources;

using System.IO.IsolatedStorage;
using System.IO;

namespace Notatnik
{
    public partial class MainPage : PhoneApplicationPage
    {
        #region Obługa pliku tekstowego
        const string ścieżkaPliku = "Katalog\\plik.txt";

        string CzytajPlikTekstowy(string ścieżkaPliku)
        {
            IsolatedStorageFile magazyn = IsolatedStorageFile.GetUserStoreForApplication();
            string tekst = String.Empty;
            try
            {
                using (StreamReader sr = new StreamReader(new IsolatedStorageFileStream(ścieżkaPliku, FileMode.Open, magazyn)))
                {
                    tekst = sr.ReadToEnd();
                }
            }
            catch (Exception exc)
            {
                MessageBox.Show(exc.Message, "Błąd oczytu pliku", MessageBoxButton.OK);
            }
            return tekst;
        }

        bool ZapiszPlikTekstowy(string ścieżkaPliku, string tekst)
        {
            IsolatedStorageFile magazyn = IsolatedStorageFile.GetUserStoreForApplication();

            if (!magazyn.DirectoryExists("Katalog")) magazyn.CreateDirectory("Katalog");            

            try
            {
                using (StreamWriter sw = new StreamWriter(new IsolatedStorageFileStream(ścieżkaPliku, FileMode.OpenOrCreate, magazyn)))
                {
                    sw.WriteLine(tekst);
                }
                return true;
            }
            catch (Exception)
            {
                return false;
            }
        }
        #endregion


        // Constructor
        public MainPage()
        {
            InitializeComponent();

            if (textBox != null) textBox.Text = CzytajPlikTekstowy(ścieżkaPliku);
            else MessageBox.Show("Problem z zainicjowaniem aplikacji");

            // Sample code to localize the ApplicationBar
            //BuildLocalizedApplicationBar();
        }

       
        private void textBox_LostFocus(object sender, RoutedEventArgs e)
        {
            if (!ZapiszPlikTekstowy(ścieżkaPliku, textBox.Text))
                MessageBox.Show("Zapisanie pliku nie powiodło się");
        }

        // Sample code for building a localized ApplicationBar
        //private void BuildLocalizedApplicationBar()
        //{
        //    // Set the page's ApplicationBar to a new instance of ApplicationBar.
        //    ApplicationBar = new ApplicationBar();

        //    // Create a new button and set the text value to the localized string from AppResources.
        //    ApplicationBarIconButton appBarButton = new ApplicationBarIconButton(new Uri("/Assets/AppBar/appbar.add.rest.png", UriKind.Relative));
        //    appBarButton.Text = AppResources.AppBarButtonText;
        //    ApplicationBar.Buttons.Add(appBarButton);

        //    // Create a new menu item with the localized string from AppResources.
        //    ApplicationBarMenuItem appBarMenuItem = new ApplicationBarMenuItem(AppResources.AppBarMenuItemText);
        //    ApplicationBar.MenuItems.Add(appBarMenuItem);
        //}
    }
}