﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Navigation;
using Microsoft.Phone.Controls;
using Microsoft.Phone.Shell;
using DataBinding2.Resources;

using System.ComponentModel;
using System.Windows.Threading;
using System.Windows.Data;
using System.Globalization;

namespace DataBinding2
{
    public partial class MainPage : PhoneApplicationPage
    {
        // Constructor
        public MainPage()
        {
            InitializeComponent();
        }
    }

    public class Zegar : INotifyPropertyChanged
    {
        //wymagane przez INotifyPropertyChanged
        public event PropertyChangedEventHandler PropertyChanged;

        //wywołanie metod przypisanych do zdarzenia
        protected void OnPropertyChanged(PropertyChangedEventArgs e)
        {
            if (PropertyChanged != null) PropertyChanged(this, e);
        }

        private int godzina, minuta, sekunda;

        public virtual int Godzina
        {
            get { return godzina; }
            private set
            {
                if (value == godzina) return; //nie zawiadamia o zmianach jeżeli ich nie ma
                godzina = value;
                OnPropertyChanged(new PropertyChangedEventArgs("Godzina"));
            }
        }

        public int Minuta
        {
            get { return minuta; }
            private set
            {
                if (value == minuta) return; //nie zawiadamia o zmianach jeżeli ich nie ma
                minuta = value;
                OnPropertyChanged(new PropertyChangedEventArgs("Minuta"));
            }
        }

        public int Sekunda
        {
            get { return sekunda; }
            private set
            {
                if (value == sekunda) return; //nie zawiadamia o zmianach jeżeli ich nie ma
                sekunda = value;
                OnPropertyChanged(new PropertyChangedEventArgs("Sekunda"));
            }
        }

        public Zegar()
        {
            DispatcherTimer timer = new DispatcherTimer();
            timer.Interval = new TimeSpan(1000);
            timer.Tick += timer_Tick;
            timer.Start();
        }

        protected virtual void timer_Tick(object sender, EventArgs e)
        {
            DateTime now = DateTime.Now;
            Godzina = now.Hour;
            Minuta = now.Minute;
            Sekunda = now.Second;
        }

        /*
        public override string ToString()
        {
            return Godzina.ToString()+":"+Minuta.ToString()+":"+Sekunda.ToString();
        }
        */
    }

    public class Zegar12H : Zegar
    {
        public override int Godzina
        {
            get
            {
                if (base.Godzina > 12) return base.Godzina - 12;
                return base.Godzina;
            }
        }

        bool amPm;

        public bool AmPm
        {
            get
            {
                return amPm;
            }
            set
            {
                if (value == amPm) return;
                amPm = value;
                OnPropertyChanged(new PropertyChangedEventArgs("AmPm"));
            }
        }

        protected override void timer_Tick(object sender, EventArgs e)
        {
            base.timer_Tick(sender, e);
            AmPm = base.Godzina > 12;
        }
    }

    public class StringFormatConverter : IValueConverter
    {
        public object Convert(object value, Type targerType, object parameter, CultureInfo culture)
        {
            if (targerType == typeof(string) && parameter is string) return string.Format(parameter as string, value);
            else return value;
        }

        public object ConvertBack(object value, Type targerType, object parameter, CultureInfo culture)
        {
            return value;
        }
    }

    public class BoolToStringAmPmConverter : IValueConverter
    {
        public object Convert(object value, Type targerType, object parameter, CultureInfo culture)
        {
            return (bool)value ? "PM" : "AM";
        }

        public object ConvertBack(object value, Type targerType, object parameter, CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }
}