﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Navigation;
using Microsoft.Phone.Controls;
using Microsoft.Phone.Shell;
using DataBinding.Resources;

using System.Windows.Data;
using System.Globalization;

namespace DataBinding
{
    public partial class MainPage : PhoneApplicationPage
    {
        // Constructor
        public MainPage()
        {
            InitializeComponent();
        }

        private void textBox1_TextChanged(object sender, TextChangedEventArgs e)
        {
            TextBox tb = sender as TextBox;
            tb.GetBindingExpression(TextBox.TextProperty).UpdateSource();
        }        
    }

    public class StringFormatConverter : IValueConverter
    {
        public object Convert(object value, Type targerType, object parameter, CultureInfo culture)
        {            
            //if (targerType == typeof(string)) return string.Format("{0:F2}", value);
            if (targerType == typeof(string) && parameter is string) return string.Format(parameter as string, value);
            else return value;
        }

        public object ConvertBack(object value, Type targerType, object parameter, CultureInfo culture)
        {
            return value;
        }
    }

    public class BooleanToVisibilityConverter : IValueConverter
    {
        public object Convert(object value, Type targerType, object parameter, CultureInfo culture)
        {
            return (bool)value ? Visibility.Visible : Visibility.Collapsed;
        }

        public object ConvertBack(object value, Type targerType, object parameter, CultureInfo culture)
        {
            return (Visibility)value == Visibility.Visible;
        }
    }

    public class DoubleToVisibilityConverter : IValueConverter
    {
        public object Convert(object value, Type targerType, object parameter, CultureInfo culture)
        {
            return ((double)value >= (double)parameter) ? Visibility.Visible : Visibility.Collapsed;
            //return ((double)value >= Double.Parse(parameter as string)) ? Visibility.Visible : Visibility.Collapsed;
        }

        public object ConvertBack(object value, Type targerType, object parameter, CultureInfo culture)
        {
            throw new NotImplementedException(); //nie implementujemy konwersji wstecz
        }
    }
}