﻿Option Strict On
Option Infer Off
Option Explicit On

'Namespace RownanieKwadratoweBibliotekaVB

Public Class RownanieKwadratowe

    Private a As Double, b As Double, c As Double
    Private delta_pierwiastek As Double? 'Nullable(Of Double)

    Private _czyPierwiastkiIstnieja As Boolean

    Public Property CzyPierwiastkiIstnieja As Boolean
        Get
            Return _czyPierwiastkiIstnieja
        End Get
        Set(value As Boolean)
            _czyPierwiastkiIstnieja = value
        End Set
    End Property

    Public Sub New(a As Double, b As Double, c As Double)
        Me.a = a
        Me.b = b
        Me.c = c

        Dim delta As Double = Me.delta
        CzyPierwiastkiIstnieja = delta >= 0
        If CzyPierwiastkiIstnieja Then delta_pierwiastek = Math.Sqrt(delta)
    End Sub

    Private Function delta() As Double
        Return b * b - 4 * a * c
    End Function

    Private ReadOnly Property DeltaPierwiastek As Double
        Get
            If delta_pierwiastek.HasValue Then
                Return delta_pierwiastek.Value
            Else
                Throw New Exception("Delta jest ujemna, pierwiastek jest liczbą urojoną")
            End If
        End Get
    End Property

    Public ReadOnly Property X1 As Double
        Get
            Return (-b - DeltaPierwiastek) / 2 / a
        End Get
    End Property

    Public ReadOnly Property X2 As Double
        Get
            Return (-b + DeltaPierwiastek) / 2 / a
        End Get
    End Property

End Class

'End Namespace