﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Threading;

namespace Watki
{
    class Program
    {
        static Random r = new Random();

        static double pi = 0;

        static double obliczPi(long liczbaPrób)
        {
            Random r = new Random(Program.r.Next());

            double x, y;
            long ilośćTrafień = 0;
            for(long i=0; i<liczbaPrób;++i)
            {
                /*
                if(i==liczbaPrób/2)
                {
                    lock(Program.r)
                    {
                        Console.WriteLine("Synchronizacja: wątek {0} osiągnął półmetek", Thread.CurrentThread.ManagedThreadId);
                    }
                }
                */

                x = r.NextDouble();
                y = r.NextDouble();
                if (x * x + y * y < 1) ilośćTrafień++;
            }
            return 4.0 * ilośćTrafień / liczbaPrób;
        }

        static void uruchamianieObliczenPi(object parametr)
        {
            try
            {
                int? indeks = parametr as int?;

                Console.WriteLine("Uruchamiam obliczenia w wątku {0}, indeks: {1}", Thread.CurrentThread.ManagedThreadId, (indeks.HasValue?indeks.Value.ToString():"---"));

                int czasPoczątkowy = Environment.TickCount;

                long liczbaPrób = 1000000000L;
                double pi = obliczPi(liczbaPrób);
                lock(r) Program.pi += pi;
                /*
                Monitor.Enter(r);
                try
                {
                    Program.pi += pi;
                }
                finally
                {
                    Monitor.Exit(r);
                }
                */

                int czasKońsowy = Environment.TickCount;

                Console.WriteLine("Pi={0}, błąd={1}", pi, Math.Abs(pi - Math.PI));
                Console.WriteLine("Czas obliczeń: " + (czasKońsowy - czasPoczątkowy).ToString() + " ms przeprowadzonych w wątku {0}", Thread.CurrentThread.ManagedThreadId);
            }
            catch(ThreadAbortException exc)
            {
                Console.WriteLine("Działąnie wątku zostało przerwane z zewnątrz (" + exc.Message + ")");
            }
            catch(Exception exc)
            {
                Console.WriteLine("Nieokreślony błąd (" + exc.Message + ")");
            }
            finally
            {
                Console.WriteLine("Zakończenie pracy wątku");
            }
        }

        const int ileWątków = 16;
        //static readonly int ileWątków = Environment.ProcessorCount;

        static void Main(string[] args)
        {
            Console.WriteLine("Uruchamian program, wątek główny: " + Thread.CurrentThread.ManagedThreadId.ToString());
            Console.WriteLine("Liczba wątków: " + ileWątków.ToString());

            //uruchamianieObliczenPi();

            //ThreadStart ts = uruchamianieObliczenPi;
            //Thread t = new Thread(ts);

            /*
            Thread t = new Thread(uruchamianieObliczenPi);
            //t.IsBackground = true;
            t.Priority = ThreadPriority.Highest;            
            t.Start();

            Thread.Sleep(1000);
            t.Suspend(); //przestarzałe
            Console.Write("Wątek wstrzymany. Naciśnij ENTER, aby go wznowić..."); Console.ReadLine();
            t.Resume(); //przestarzałe
            Console.WriteLine("Wątek wznowiony");

            Console.WriteLine("Naciśnij ENTER aby przerwać wątek..."); Console.ReadLine();
            t.Abort();
            */

            /*
            Thread[] tt = new Thread[ileWątków];
            for (int i = 0; i < ileWątków; ++i)
            {
                tt[i] = new Thread(uruchamianieObliczenPi);
                tt[i].Priority = ThreadPriority.Lowest;
                tt[i].Start(i);
            }

            foreach(Thread t in tt)
            {
                t.Join();
                Console.WriteLine("Zakończył działanie wątek nr {0}", t.ManagedThreadId);
            }

            Program.pi/=ileWątków;
            Console.WriteLine("Uśredniona wartość liczby pi: " + Program.pi.ToString() + ", błąd: " + (Program.pi - Math.PI).ToString());
            */

            ThreadPool.SetMaxThreads(30, 100);
            for (int i = 0; i < ileWątków; i++)
            {
                ThreadPool.QueueUserWorkItem(uruchamianieObliczenPi, i);
            }

            int ileDostepnychWatkowWPuli = 0;
            int ileWszystkichWatkowWPuli = 0;
            int ileDzialajacychWatkowWPuli = 0;
            int tmp;
            do
            {
                ThreadPool.GetAvailableThreads(out ileDostepnychWatkowWPuli, out tmp);
                ThreadPool.GetMaxThreads(out ileWszystkichWatkowWPuli, out tmp);
                ileDzialajacychWatkowWPuli = ileWszystkichWatkowWPuli - ileDostepnychWatkowWPuli;
                Console.WriteLine("Ilość aktywnych wątków w puli: {0}", ileDzialajacychWatkowWPuli);
                Thread.Sleep(1000);
            }
            while (ileDzialajacychWatkowWPuli > 0);

            Program.pi /= ileWątków;
            Console.WriteLine("Uśredniona wartość liczby pi: " + Program.pi.ToString() + ", błąd: " + (Program.pi - Math.PI).ToString());


            Console.WriteLine("Czy to pojawi się po zakończeniu obliczeń?");
        }
    }
}
