﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ZaawansowaneProgramowanieObiektowe
{
    class Program
    {
        #region Osoba
        class Osoba /*: object*/
        {
            public string Imię;
            public string Nazwisko;
            public int Wiek;

            public override string ToString()
            {
                return Imię + " " + Nazwisko + " (" + Wiek.ToString() + ")";
            }
        }

        class Adres
        {
            public string Miasto;
            public string Ulica;
            public int NumerDomu;
            public int? NumerMieszkania;

            public override string ToString()
            {
                return Miasto + ", ul. " + Ulica + " " + NumerDomu.ToString() + (NumerMieszkania.HasValue?("/" + NumerMieszkania.ToString()):"");
            }
        }

        class OsobaZameldowana : Osoba
        {
            public Adres AdresZameldowania;

            //public string ToString() //ukrywanie, przesłanianie
            //public new string ToString() //ukrywanie, przesłanianie            
            public override string ToString() //nadpisywanie
            {
                return base.ToString() + "; " + AdresZameldowania.ToString();
            }
        }
        
        static void Main_Osoba()
        {
            Osoba o = new Osoba() { Imię = "Karolina", Nazwisko = "Olech", Wiek = 18 };
            Console.WriteLine(o.ToString());

            OsobaZameldowana oz = new OsobaZameldowana() 
            { 
                Imię = "Karolina", 
                Nazwisko = "Olech", 
                Wiek = 18, 
                AdresZameldowania = new Adres() 
                { 
                    Miasto = "Inowrocław", 
                    Ulica = "Konwaliowa", 
                    NumerDomu = 1, 
                    NumerMieszkania = 2 
                } 
            };
            Console.WriteLine(oz.ToString());

            Osoba oo = new OsobaZameldowana()
            {
                Imię = "Karolina",
                Nazwisko = "Olech",
                Wiek = 18,
                AdresZameldowania = new Adres()
                {
                    Miasto = "Inowrocław",
                    Ulica = "Konwaliowa",
                    NumerDomu = 1,
                    NumerMieszkania = 2
                }
            };
            Console.WriteLine(oo.ToString());
        }
        #endregion

        #region Figura
        abstract class Figura
        {
            public Figura()
            {
                Console.WriteLine("Konstruktor klasy bazowej");
            }

            public Figura(string argument)
            {
                Console.WriteLine("Konstruktor klasy bazowej, argument: "+argument);
            }

            public abstract int IleWierzchołków();

            public virtual int LiczbaWierzchołków
            {
                get
                {
                    return IleWierzchołków();
                }
            }
        }

        class Prostokąt : Figura
        {
            public Prostokąt()
            {
                Console.WriteLine("Konstruktor klasy Prostokąt");
            }

            public Prostokąt(string argument)
                : base(argument)
            {
                Console.WriteLine("Konstruktor klasy Prostokąt, argument: "+argument);
            }

            public override int IleWierzchołków()
            {
                return 4;
            }
        }

        class Kwadrat : Prostokąt
        {
            public Kwadrat()
            {
                Console.WriteLine("Konstruktor klasy Kwadrat");
            }

            public Kwadrat(string argument)
                :base(argument)
            {
                Console.WriteLine("Konstruktor klasy Kwadrat, argument: " + argument);
            }

            public override int LiczbaWierzchołków
            {
                get
                {
                    return -IleWierzchołków();
                }
            }
        }

        class Okrąg : Figura
        {
            public override int IleWierzchołków()
            {
                return 0;
            }
        }

        class Trójkąt : Figura
        {
            public override int IleWierzchołków()
            {
                return 3;
            }
        }

        //polimorfizm

        static void Main_Figura()
        {
            Figura figura = new Kwadrat();
            Figura[] figury = new Figura[4] { new Prostokąt(), new Trójkąt(), new Kwadrat(), new Okrąg() };
            foreach (Figura f in figury) Console.WriteLine(f.GetType().Name + ", liczba wierzchołków: " + f.IleWierzchołków() + " = " + f.LiczbaWierzchołków);

            Figura figura1 = new Kwadrat();
            Console.WriteLine();
            Figura figura2 = new Kwadrat("argument");
        }
        #endregion

        #region Singleton
        public class KlasaZwykła //ze statycznym polem
        {
            public static int Licznik = 0;

            public KlasaZwykła()
            {
                Licznik++;
            }
        }

        public static class KlasaStatyczna
        {
            private static string pole = "Domyślna wartość pola";

            public static string Pole
            {
                get
                {
                    return pole;
                }
                set
                {
                    pole = value;
                }
            }

            public static void Metoda()
            {
                Console.WriteLine(pole);
            }
        }


        public class Singleton1
        {
            public const int MaksymalnaLiczbaInstancji = 3;

            public static int Licznik = 0;

            public Singleton1()
            {                
                if (Licznik >= MaksymalnaLiczbaInstancji) throw new Exception("Nie można utworzyć większej liczby instancji");
                Licznik++;
            }
        }

        public class Klasa
        {

        }

        public sealed class Singleton2 : Klasa //jedyną instancję przechowuję w statycznym polu
        {
            private Singleton2() {} //ukryty konstruktor

            private static Singleton2 instancja = new Singleton2();

            public static Singleton2 Instancja
            {
                get
                {
                    return instancja;
                }
            }
        }

        public sealed class Singleton3 : Klasa //jedyną instancję przechowuję w statycznym polu
        {
            private Singleton3() { } //ukryty konstruktor

            private static Singleton3 instancja = null;

            public static Singleton3 Instancja
            {
                get
                {
                    if (instancja == null) instancja = new Singleton3();
                    return instancja;
                }
            }
        }

        static void Main_Singleton()
        {
            for (int i = 0; i < 10; ++i)
            {
                new KlasaZwykła();
                Console.WriteLine("Ile obiektów klasy KlasaZwykła: " + KlasaZwykła.Licznik);
            }

            //KlasaStatyczna ks = new KlasaStatyczna();
            KlasaStatyczna.Pole = "Nowa wartość pola";
            KlasaStatyczna.Metoda();

            for (int i = 0; i < 10; ++i)
            {
                try
                {
                    new Singleton1();
                    Console.WriteLine("Ile obiektów klasy KlasaZwykła: " + Singleton1.Licznik);
                }
                catch(Exception exc)
                {
                    Console.Error.WriteLine(exc.Message);
                }
            }

            //Singleton2 singleton2 = new Singleton2();
            Singleton2 singleton2 = Singleton2.Instancja;

            Singleton3 singleton3 = Singleton3.Instancja;
        }
        #endregion

        #region Definiowanie interfejsów

        interface IPosiadaTelefon
        {
            int? NumerTelefonu { get; set; }
        }

        class OsobaZTelefonem : Osoba, IPosiadaTelefon
        {
            private int? numerTelefonu;

            public int? NumerTelefonu
            {
                get
                {
                    return numerTelefonu;
                }
                set
                {
                    numerTelefonu = value;
                }
            }

            public bool CzyPosiadaTelefon
            {
                get
                {
                    return numerTelefonu.HasValue;
                }
            }
        }

        static void Main_DefiniowanieInterfejsów()
        {
            OsobaZTelefonem ot = new OsobaZTelefonem() { Imię = "Karolina", Nazwisko = "Olech", Wiek = 18, NumerTelefonu = 123456789 };
            Osoba o = new OsobaZTelefonem() { Imię = "Karolina", Nazwisko = "Olech", Wiek = 18, NumerTelefonu = 123456789 };
            IPosiadaTelefon pt = new OsobaZTelefonem() { Imię = "Karolina", Nazwisko = "Olech", Wiek = 18, NumerTelefonu = 123456789 };

            Console.WriteLine(ot.Imię + ": " + ot.NumerTelefonu);
            Console.WriteLine(o.Imię);
            Console.WriteLine(pt.NumerTelefonu);
        }
        #endregion

        static void Main(string[] args)
        {
            //Main_Osoba();
            Console.WriteLine();

            //Main_Figura();
            Console.WriteLine();

            //Main_Singleton();
            Console.WriteLine();

            Main_DefiniowanieInterfejsów();
            Console.WriteLine();            
        }
    }
}
