﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace AsyncAwait
{
    class Program
    {
        static void Console_WriteLine(string tekst)
        {
            string numerWątku = System.Threading.Thread.CurrentThread.ManagedThreadId.ToString();
            string numerZadania = Task.CurrentId.HasValue ? Task.CurrentId.Value.ToString() : "-";
            Console.WriteLine("[wątek: " + numerWątku + ", zadanie: " + numerZadania + "] " + tekst);
        }

        static Task<long> ZróbCośAsync(object argument)
        {
            Console_WriteLine("ZróbCośAsync - początek");

            //czynność
            Func<object, long> akcja =
                (object _argument) =>
                {
                    Console_WriteLine("Początek działania akcji, argument: " + _argument.ToString());
                    System.Threading.Thread.Sleep(500);
                    Console_WriteLine("Koniec działania akcji");
                    //return DateTime.Now.Ticks;
                    return System.Environment.TickCount;
                };

            Task<long> zadanie = new Task<long>(akcja, "zadanie");
            zadanie.Start();
            Console_WriteLine("ZróbCośAsync - po uruchomieniu zadania, koniec");

            return zadanie;
        }

        static async void Main_Async(string[] args)
        {
            Console_WriteLine("Main_Async - początek");

            Task<long> zadanie = ZróbCośAsync("ZróbCośAsync");
            Console_WriteLine("Main_Async - po wywołaniu ZróbCośAsync");
            //long wynik = zadanie.Result; //punkt synchronizacji
            long wynik = await zadanie; //to nie jest punkt synchronizacji
            Console_WriteLine("Main_Async - po zakończeniu akcji, wynik: " + wynik.ToString());
        }

        static void Main(string[] args)
        {
            Console_WriteLine("Main - początek");
            Main_Async(args);            
            Console_WriteLine("Tu czekam w wątku głównym na naciśnięcie Enter"); Console.ReadLine();
            Console_WriteLine("Main - koniec");
        }
    }
}
