﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace AsyncAwait
{
    class Program
    {
        //delegate long Func(object argument);

        static void Main_Sekwencyjnie(string[] args)
        {
            Console.WriteLine("Main - początek");

            //czynność
            Func<object, long> akcja =
                (object argument) =>
                {
                    Console.WriteLine("Początek działania akcji, argument: " + argument.ToString());
                    System.Threading.Thread.Sleep(500);
                    Console.WriteLine("Koniec działania akcji");
                    //return DateTime.Now.Ticks;
                    return System.Environment.TickCount;
                };
            
            long wynik = akcja("sekwencyjnie");
            Console.WriteLine("Main - po zakończeniu akcji, wynik: " + wynik.ToString());
        }

        static void Main_Zadanie(string[] args)
        {
            Console.WriteLine("Main - początek");

            //czynność
            Func<object, long> akcja =
                (object argument) =>
                {
                    Console.WriteLine("Początek działania akcji, argument: " + argument.ToString());
                    System.Threading.Thread.Sleep(500);
                    Console.WriteLine("Koniec działania akcji");
                    //return DateTime.Now.Ticks;
                    return System.Environment.TickCount;
                };

            //long wynik = akcja("sekwencyjnie");
            Task<long> zadanie = new Task<long>(akcja, "zadanie");
            zadanie.Start();
            Console.WriteLine("Main - po uruchomieniu zadania");
            long wynik = zadanie.Result; //punkt synchronizacji
            Console.WriteLine("Main - po zakończeniu akcji, wynik: " + wynik.ToString());
            //Console.WriteLine("Main - po zakończeniu akcji");
        }

        static Task<long> ZróbCośAsync(object argument)
        {
            Console.WriteLine("ZróbCośAsync - początek");

            //czynność
            Func<object, long> akcja =
                (object _argument) =>
                {
                    Console.WriteLine("Początek działania akcji, argument: " + _argument.ToString());
                    System.Threading.Thread.Sleep(500);
                    Console.WriteLine("Koniec działania akcji");
                    //return DateTime.Now.Ticks;
                    return System.Environment.TickCount;
                };

            Task<long> zadanie = new Task<long>(akcja, "zadanie");
            zadanie.Start();
            Console.WriteLine("ZróbCośAsync - po uruchomieniu zadania, koniec");

            return zadanie;
        }

        static void Main_ZróbCośAsync(string[] args)
        {
            Console.WriteLine("Main - początek");

            Task<long> zadanie = ZróbCośAsync("ZróbCośAsync");
            Console.WriteLine("Main - po wywołaniu ZróbCośAsync");            
            long wynik = zadanie.Result; //punkt synchronizacji
            Console.WriteLine("Main - po zakończeniu akcji, wynik: " + wynik.ToString());            
        }

        static async void Main_Async(string[] args)
        {
            Console.WriteLine("Main_Async - początek");

            Task<long> zadanie = ZróbCośAsync("ZróbCośAsync");
            Console.WriteLine("Main_Async - po wywołaniu ZróbCośAsync");
            //long wynik = zadanie.Result; //punkt synchronizacji
            long wynik = await zadanie; //to nie jest punkt synchronizacji
            Console.WriteLine("Main_Async - po zakończeniu akcji, wynik: " + wynik.ToString());
        }

        static void Main(string[] args)
        {
            Console.WriteLine("Main - początek");
            Main_Async(args);
            Console.WriteLine("Main - koniec");
            Console.WriteLine("Tu czekam w wątku głównym na naciśnięcie Enter"); Console.ReadLine();
        }
    }
}
