﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;

using Umk.Wfaiis.Pspizk.BibliotekaPrzenosna;

namespace UlamekTesty
{
    [TestClass]
    public class UlamekTesty
    {
        [TestMethod]
        public void TestowanieKonstruktoraIWlasnosci()
        {
            //przygotowanie
            int licznik = 1;
            int mianownik = 2;

            //dzialanie
            Ułamek u = new Ułamek(licznik, mianownik);

            //weryfikacja
            Assert.AreEqual(licznik, u.Licznik);
            Assert.AreEqual(mianownik, u.Mianownik);
        }

        [TestMethod]
        public void TestSamegoKonstruktora()
        {
            int licznik = 1;
            int mianownik = 2;

            Ułamek u = new Ułamek(licznik, mianownik);

            PrivateObject po = new PrivateObject(u);
            int u_mianownik = (int)po.GetField("mianownik");
            Assert.AreEqual(mianownik, u_mianownik);
        }

        [TestMethod]
        [ExpectedException(typeof(DivideByZeroException))]
        public void TestKonstruktoraWyjatek()
        {
            Ułamek u = new Ułamek(1, 0);
        }

        [TestMethod]
        public void TestPolowa()
        {
            Ułamek polowa = Ułamek.Połowa;
            Assert.AreEqual(1, polowa.Licznik);
            Assert.AreEqual(2, polowa.Mianownik);
        }

        [TestMethod]
        public void TestOperatorow()
        {
            Ułamek a = Ułamek.Połowa;
            Ułamek b = new Ułamek(1, 4);

            Assert.AreEqual(new Ułamek(3, 4).ToDouble(), (a + b).ToDouble(), "Niepowodzenie przy dodawaniu");
            Assert.AreEqual(new Ułamek(1, 4).ToDouble(), (a - b).ToDouble(), "Niepowodzenie przy odejmowaniu");
            Assert.AreEqual(new Ułamek(1, 8).ToDouble(), (a * b).ToDouble(), "Niepowodzenie przy mnożeniu");
            Assert.AreEqual(new Ułamek(2, 1).ToDouble(), (a / b).ToDouble(), "Niepowodzenie przy dzieleniu");

            Assert.AreEqual(new Ułamek(3, 4), a + b, "Niepowodzenie przy dodawaniu");
            Assert.AreEqual(new Ułamek(1, 4), a - b, "Niepowodzenie przy odejmowaniu");
            Assert.AreEqual(new Ułamek(1, 8), a * b, "Niepowodzenie przy mnożeniu");
            Assert.AreEqual(new Ułamek(2, 1), a / b, "Niepowodzenie przy dzieleniu");
        }

        [TestMethod]
        public void TestMetodyUprosc()
        {
            Ułamek u1 = new Ułamek(6, 8);
            Ułamek u2 = new Ułamek(-6, 8);
            Ułamek u3 = new Ułamek(6, -8);
            Ułamek u4 = new Ułamek(-6, -8);

            u1.Uprość();
            u2.Uprość();
            u3.Uprość();
            u4.Uprość();

            Ułamek oczekiwany = new Ułamek(3, 4);
            Ułamek oczekiwanyUjemny = new Ułamek(-3, 4);

            Assert.AreEqual(oczekiwany, u1);
            Assert.AreEqual(oczekiwany, u4);
            Assert.AreEqual(oczekiwanyUjemny, u2);
            Assert.AreEqual(oczekiwanyUjemny, u3);
        }

        Random r = new Random();

        [TestMethod]
        public void TestSortowania()
        {
            Ułamek[] tablica = new Ułamek[100];
            for (int i = 0; i < tablica.Length; ++i)
            {
                tablica[i] = new Ułamek(losujLiczbeCalkowita(), losujLiczbeCalkowitaRoznaOdZera());
            }

            Array.Sort(tablica);

            bool czyPosortowanaRosnaco = true;
            for (int i = 0; i < tablica.Length - 1; ++i)
            {
                if (tablica[i].ToDouble() > tablica[i + 1].ToDouble()) czyPosortowanaRosnaco = false;
            }
            Assert.IsTrue(czyPosortowanaRosnaco);
        }

        private int losujLiczbeCalkowita(int? maksymalnaWartoscBezwzgledna = null)
        {
            if (!maksymalnaWartoscBezwzgledna.HasValue) return r.Next(int.MinValue, int.MaxValue);
            else
            {
                maksymalnaWartoscBezwzgledna = Math.Abs(maksymalnaWartoscBezwzgledna.Value);
                return r.Next(-maksymalnaWartoscBezwzgledna.Value, maksymalnaWartoscBezwzgledna.Value);
            }
        }

        private int losujLiczbeCalkowitaRoznaOdZera(int? maksymalnaWartoscBezwzgledna = null)
        {
            int wartosc;
            do
            {
                wartosc = losujLiczbeCalkowita(maksymalnaWartoscBezwzgledna);
            }
            while (wartosc == 0);
            return wartosc;
        }

        [TestMethod]
        public void TestowanieKonstruktoraIWlasnosci2()
        {
            for (int i = 0; i < 1000; ++i)
            {
                //przygotowanie
                int licznik = losujLiczbeCalkowita();
                int mianownik = losujLiczbeCalkowitaRoznaOdZera();

                //dzialanie
                Ułamek u = new Ułamek(licznik, mianownik);

                //weryfikacja
                Assert.AreEqual(licznik, u.Licznik);
                Assert.AreEqual(mianownik, u.Mianownik);
            }
        }

        [TestMethod]
        public void TestowanieKonwersjiZInt()
        {
            for (int i = 0; i < 1000; ++i)
            {
                int licznik = losujLiczbeCalkowita();

                Ułamek u = licznik;

                Assert.AreEqual(licznik, u.Licznik);
                Assert.AreEqual(1, u.Mianownik);
            }
        }

        [TestMethod]
        public void TestMetodyUprosc2()
        {
            for (int i = 0; i < 100; ++i)
            {
                Ułamek u = new Ułamek(losujLiczbeCalkowita(), losujLiczbeCalkowitaRoznaOdZera());
                //Ułamek u = new Ułamek(123456789, 123456788);
                Ułamek kopia = u;

                u.Uprość();

                double expected = kopia.ToDouble();
                double actual = u.ToDouble();
                Assert.AreEqual(expected, actual, 1E-10);
            }
        }

        [TestMethod]
        public void TestDodawania()
        {
            int maksymalnaWartoscBezwzgledna = (int)Math.Sqrt(int.MaxValue / 2);

            for (int i = 0; i < 100; ++i)
            {
                Ułamek a = new Ułamek(losujLiczbeCalkowita(maksymalnaWartoscBezwzgledna), losujLiczbeCalkowitaRoznaOdZera(maksymalnaWartoscBezwzgledna));
                Ułamek b = new Ułamek(losujLiczbeCalkowita(maksymalnaWartoscBezwzgledna), losujLiczbeCalkowitaRoznaOdZera(maksymalnaWartoscBezwzgledna));                
                
                double expected = a.ToDouble()+b.ToDouble();
                double actual = (a+b).ToDouble();
                Assert.AreEqual(expected, actual, 1E-10);
            }
        }
    }
}
