﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ProgramowanieObiektowe
{
    class Samochód
    {
        //enum 

        private bool silnikWłączony = false;
        private int bieg = 0;

        public bool CzySamochódJedzie
        {
            get
            {
                return silnikWłączony && bieg > 0;
            }
        }

        public int Bieg
        {
            get
            {
                return bieg;
            }
            set
            {
                if (value < 0 || value > 6) throw new ArgumentException("Dopuszczalne biegi z zakresu 0-6");
                bieg = value;
                Console.WriteLine("Zmieniłem bieg na " + bieg);                
            }
        }

        public void WłączSilnik()
        {
            silnikWłączony = true;
            Console.WriteLine("Silnik włączony");
        }

        public void WyłączSilnik()
        {
            silnikWłączony = false;
            Console.WriteLine("Silnik wyłączony");
        }

        public override string ToString()
        {
            return (CzySamochódJedzie ? "Samochód jedzie" : "Samochód stoi") + ", bieg: " + Bieg.ToString();
        }
    }

    class SamochódOsobowy : Samochód
    {
        public const int MaksymalnaLiczbaPasażerów = 5;

        int liczbaPasażerów = 0;

        public void DodajPasażera()
        {
            if (liczbaPasażerów + 1 > MaksymalnaLiczbaPasażerów) throw new Exception("Więcej pasażerów już się nie zmieści");
            liczbaPasażerów++;
        }

        public void WysadźPasażera()
        {
            if (liczbaPasażerów == 0) throw new Exception("Samochód jest już pusty");
            liczbaPasażerów--;
        }

        public override string ToString()
        {
            return base.ToString() + ", liczba pasażerów: " + liczbaPasażerów.ToString();
        }
    }
}
