﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using Umk.Wfaiis.Pspizk.BibliotekaPrzenosna;

namespace ProgramowanieObiektowe
{
    //szablon klasy
    class Klasa /*: Object*/
    {
        private int pole = 1;
        private int kopiaPola;

        public int Własność
        {
            get
            {
                return pole;
            }
            set
            {
                pole = value;
                kopiaPola = pole;
            }
        }

        public Klasa() //konstruktor bezarumentowy = domyślny
        {
            Własność = 0;
        }

        public Klasa(int pole) //konstruktor
        {
            Własność = pole;
        }

        public void ZerujPole()
        {
            //pole = 0;
            Własność = 0;
        }

        public override string ToString()
        {
            string nazwaTypu = base.ToString();
            string wartośćPola = "Pole: " + Własność;
            return nazwaTypu + "\n" + wartośćPola;
        }

        public Klasa Klonuj()
        {
            return new Klasa(this.Własność);
        }
    }

    struct Struktura
    {
        private int pole; //nie można tu inicjować w strukturach
        private int kopiaPola;

        public int Własność
        {
            get
            {
                return pole;
            }
            set
            {
                pole = value;
                kopiaPola = pole;
            }
        }

        //konstruktor bezarumentowy = domyślny jest niedopuszczalny w strukturach

        public Struktura(int pole) //konstruktor
        {
            this.pole = pole;
            kopiaPola = pole;
        }

        public void ZerujPole()
        {
            //pole = 0;
            Własność = 0;
        }

        public override string ToString()
        {
            string nazwaTypu = base.ToString();
            string wartośćPola = "Pole: " + Własność;
            return nazwaTypu + "\n" + wartośćPola;
        }
    }

    class Program
    {
        static void Przykłady()
        {
            /*
            Klasa obiekt; //tu tylko deklaruję referencję
            obiekt = new Klasa(1); //tu powstaje instancja
            obiekt.ZerujPole();
            obiekt.Własność = 2;
            Console.WriteLine(obiekt.ToString());
            Console.WriteLine(obiekt.Własność.ToString());
            //obiekt.pole = 2;

            Console.WriteLine();

            Struktura obiekt2; //tu powstaje instancja            
            obiekt2.pole = 1;
            */

            Console.WriteLine();

            //typ referencyjny
            Klasa referencja1 = new Klasa(2);
            Klasa referencja2 = referencja1; //kopiowanie referencji
            referencja1.Własność = 3;
            Console.WriteLine(referencja2.ToString());

            //typ wartościowy            
            Struktura os1 = new Struktura(2);
            Struktura os2 = os1; //klonowanie
            os1.Własność = 3;
            Console.WriteLine(os2.ToString());

            Console.WriteLine();

            /*
            Kot mruczek = new Kot(false);
            Console.WriteLine(mruczek.ToString());
            mruczek.Miauczy("Miauuu (początek)");
            if (mruczek.PełnyBrzuch) mruczek.IdźNaSpacer();
            else
            {
                mruczek.Jedz();
                //mruczek.IdźNaSpacer();
            }
            mruczek.Miauczy("Miauuu (koniec)");
            */

            /*
            Samochód samochód = new Samochód();
            Console.WriteLine("Stan samochodu: " + samochód);
            samochód.WłączSilnik();
            Console.WriteLine("Stan samochodu: " + samochód);
            samochód.Bieg = 1;
            Console.WriteLine("Stan samochodu: " + samochód);
            samochód.Bieg = 0;
            Console.WriteLine("Stan samochodu: " + samochód);
            samochód.WyłączSilnik();
            Console.WriteLine("Stan samochodu: " + samochód);
            */
        }

        static void Main(string[] args)
        {
            try
            {
                Ułamek _u = new Ułamek(123456789, 123456789);
                Ułamek kopia = _u;
                _u.Uprość();
                double expected = kopia.ToDouble();
                double actual = _u.ToDouble();
                Console.WriteLine("E: " + expected + ", A: " + actual);
                return;

                Ułamek u = new Ułamek();
                u.Licznik = 1;
                u.Mianownik = 2;
                Console.WriteLine("Ułamek: " + u);
                Console.WriteLine("Suma: " + (u + u).ToString());
                Console.WriteLine("Różnica: " + (u - u).ToString());
                Console.WriteLine("Iloczyn: " + (u * u).ToString());
                Console.WriteLine("Iloraz: " + (u / u).ToString());

                Console.WriteLine();

                Ułamek u1 = new Ułamek(1, 2);
                Ułamek u2 = new Ułamek(2, 3);
                Console.WriteLine("Suma: " + (u1 + u2).ToString());
                Console.WriteLine("Różnica: " + (u1 - u2).ToString());
                Console.WriteLine("Iloczyn: " + (u1 * u2).ToString());
                Console.WriteLine("Iloraz: " + (u1 / u2).ToString());

                Console.WriteLine();

                //Ułamek odwrotny = Ułamek.ObliczOdwrotny(u);
                Ułamek odwrotny = u.Odwrotność();

                Console.WriteLine();

                Console.WriteLine("Zero: " + Ułamek.Zero);
                Console.WriteLine("Połowa: " + Ułamek.Połowa);
                Console.WriteLine("Jeden: " + Ułamek.Jeden);

                Ułamek u3 = new Ułamek(3) + Ułamek.Połowa + Ułamek.Jeden;
                Console.WriteLine("u3=" + u3);
                Console.WriteLine("u3=" + u3.ToDouble());
                Console.WriteLine("u3=" + (double)u3);

                Console.WriteLine("0.1+1/3=" + (0.1+(double)new Ułamek(1,3)));

                Ułamek u4 = 3 + Ułamek.Połowa;
                Console.WriteLine("u4=" + u4);

                //rozszerzenia
                Rozsrzerzenia.PiszWartośćWKonsoli(u3);
                u3.PiszWartośćWKonsoli();                
            }
            catch (Exception exc)
            {
                Console.WriteLine("Błąd: " + exc.Message);
            }

            Pers miauczek = new Pers();
            miauczek.Miauczy("cokolwiek");
            miauczek.Głaskaj(false);


            SamochódOsobowy samochód = new SamochódOsobowy();
            Console.WriteLine("Stan samochodu: " + samochód);
            samochód.DodajPasażera();
            samochód.WłączSilnik();
            Console.WriteLine("Stan samochodu: " + samochód);
            samochód.Bieg = 1;
            Console.WriteLine("Stan samochodu: " + samochód);
            samochód.Bieg = 0;
            Console.WriteLine("Stan samochodu: " + samochód);
            samochód.WyłączSilnik();
            Console.WriteLine("Stan samochodu: " + samochód);
            samochód.WysadźPasażera();
            Console.WriteLine("Stan samochodu: " + samochód);

        } //koniec metody Main
    } //koniec klasy Program

    static class Rozsrzerzenia
    {
        static public void PiszWartośćWKonsoli(this Ułamek u)
        {
            Console.WriteLine("Wartość ułamka: " + u.ToString());            
        }

        static public void GłosSamochodu(this Samochód s)
        {
            Console.WriteLine("Brrrrrrrr....");
        }
    }

} //koniec przestrzeni nazw
