﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Net.Http;  
using System.Web.Http;

using WebApplication1.Models;

namespace UslugaREST.Controllers
{
    [RoutePrefix("api/wpisy")]
    public class WpisyController : ApiController
    {
        public string Get()
        {
            return "Hello World!";
            //return "GET: liczby, wszystkie";
        }

        const string nazwaPlikuXml = @"d:\JacekMatulewski\wpisy.xml";
        Wpisy wpisy = new Wpisy(nazwaPlikuXml);

        [HttpGet]
        [Route("liczba")]
        public int PobierzLiczbę()
        {
            return wpisy.Liczba;
        }

        [HttpGet]
        [Route("wszystkie")]
        public Wpis[] PobierzWszystkie()
        {
            int liczbaWpisów = PobierzLiczbę();
            Wpis[] tablicaWpisów = new Wpis[liczbaWpisów];
            for (int i = 0; i < liczbaWpisów; ++i)
                tablicaWpisów[i] = wpisy.Pobierz(i);
            return tablicaWpisów;
        }

        [HttpGet]
        [Route("indeks/{indeks}")]
        [Route("{indeks}")]
        public Wpis Pobierz(int indeks)
        {
            if (indeks < 0 || indeks >= wpisy.Liczba)
                throw new ArgumentException("Liczba spoza dopuszczalnego zakresu");
            else return wpisy.Pobierz(indeks);
        }

        [HttpGet]
        [Route("indeksy/{indeksOd}-{indeksDo}")]
        public Wpis[] Pobierz(int indeksOd, int indeksDo)
        {
            if (indeksOd < 0 || indeksOd >= wpisy.Liczba)
                throw new ArgumentException("Argument 'indeksOd' spoza dopuszczalnego zakresu");
            if (indeksDo < 0 || indeksDo >= wpisy.Liczba)
                throw new ArgumentException("Argument 'indeksDo' spoza dopuszczalnego zakresu");
            Wpis[] tablicaWpisów = new Wpis[indeksDo - indeksOd + 1];
            for (int i = indeksOd; i <= indeksDo; ++i)
                tablicaWpisów[i - indeksOd] = wpisy.Pobierz(i);
            return tablicaWpisów;
        }

        [HttpPost]
        [Route("dodaj")]
        public void Dodaj(Wpis wpis)
        {
            wpisy.Dodaj(wpis);
        }
    }
}
