﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace WebApplication1.Controllers
{
    using Models;

    public class KsiegaGosciController : Controller
    {
        //const string nazwaPlikuXml = @"d:\JacekMatulewski\wpisy.xml";
        //Wpisy wpisy = new Wpisy(nazwaPlikuXml);
        Wpisy wpisy = new Wpisy();

        // GET: KsiegaGosci
        public ActionResult Index()
        {
            //return View(wpisy);

            ViewData.Add("wpisy", wpisy);
            return View(new Wpis());
        }

        /*
        //POST
        [HttpPost]
        public ActionResult Index(FormCollection formularz)
        {
            string nazwaUżytkownika = formularz["NazwaUżytkownika"];
            string treść = formularz["Treść"];

            if (nazwaUżytkownika != "" && treść != "")
            {
                Wpis wpis = new Wpis(
                    nazwaUżytkownika,
                    treść,
                    DateTime.Now,
                    Request.UserHostAddress);
                wpisy.Dodaj(wpis);

                zapamiętajNazwęUżytkownika(nazwaUżytkownika);
                ViewData.Add("nazwaOstatniegoUżytkownika", nazwaUżytkownika);
            }

            ViewData.Add("wpisy", wpisy);
            return View(new Wpis());
        }
        */

        //POST
        [HttpPost]
        public ActionResult Index(Wpis nowyWpis)
        {
            if (ModelState.IsValid)
            {                
                wpisy.Dodaj(nowyWpis);

                zapamiętajNazwęUżytkownika(nowyWpis.NazwaUżytkownika);
                ViewData.Add("nazwaOstatniegoUżytkownika", nowyWpis.NazwaUżytkownika);
            }

            ViewData.Add("wpisy", wpisy);
            return View(new Wpis());
        }

        private const string nazwaCiasteczka = "nazwaUżytkownika";

        private void zapamiętajNazwęUżytkownika(string nazwaUżytkownika)
        {
            HttpCookie ciasteczko = new HttpCookie(nazwaCiasteczka, nazwaUżytkownika);
            ciasteczko.Expires = DateTime.Now.AddDays(3);
            Response.Cookies.Add(ciasteczko);
        }
    }
}