﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Web;
using System.Xml.Linq;

namespace WebApplication1.Models
{
    public class Wpis
    {
        private string nazwaUżytkownika;
        private string treść;
        private DateTime data;
        private string adresIP;

        public string NazwaUżytkownika
        {
            get
            {
                return nazwaUżytkownika;
            }
        }

        public string Treść { get { return treść; } }
        public DateTime Data { get { return data; } }
        public string AdresIP { get { return adresIP; } }

        public Wpis(string nazwaUżytkownika, string treść, DateTime data, string adresIP)
        {
            this.nazwaUżytkownika = nazwaUżytkownika;
            this.treść = treść;
            this.data = data;
            this.adresIP = adresIP;
        }
    }

    public class Wpisy
    {
        private List<Wpis> wpisy = new List<Wpis>();
        public bool ZapiszDoPlikuPoKażdejZmianie = true;
        string nazwaPlikuXml;
        const string nazwaPlikuLog = @"d:\JacekMatulewski\log.txt";

        public bool ZapiszDoPlikuXml()
        {
            try
            {
                XDocument xml = new XDocument(
                    new XDeclaration("1.0", "utf-8", "yes"),
                    new XElement("Wpisy",
                        new XElement("DataZapisu", DateTime.Now.ToString()),
                        from wpis in wpisy //LINQ = SQL zanurzony w C#
                    select new XElement("Wpis",
                            new XElement("NazwaUżytkownika", wpis.NazwaUżytkownika),
                            new XElement("Treść", wpis.Treść),
                            new XElement("Data", wpis.Data.ToString()),
                            new XElement("AdresIP", wpis.AdresIP)
                        )
                    )
                );
                xml.Save(nazwaPlikuXml);
                return true;
            }
            catch(Exception exc) //wyjątek
            {
                System.IO.File.AppendAllText(
                    nazwaPlikuLog, "Błąd przy zapisie (" + DateTime.Now.ToString() + "): " + exc.Message);
                return false;
            }
        }
        private bool czytajZPlikuXml()
        {
            try
            {
                XDocument xml = XDocument.Load(nazwaPlikuXml);

                IEnumerable<Wpis> odczytaneWpisy =
                    from wpisXml in xml.Root.Elements("Wpis")
                    select
                        new Wpis(
                            wpisXml.Element("NazwaUżytkownika").Value,
                            wpisXml.Element("Treść").Value,
                            DateTime.Parse(wpisXml.Element("Data").Value),
                            wpisXml.Element("AdresIP").Value);

                wpisy.Clear();
                wpisy.AddRange(odczytaneWpisy);

                return true;
            }
            catch(Exception exc)
            {
                System.IO.File.AppendAllText(
                    nazwaPlikuLog, "Błąd przy odczycie (" + DateTime.Now.ToString() + "): " + exc.Message);
                return false;
            }
        }
        public void Dodaj(Wpis wpis)
        {
            wpisy.Add(wpis);
            if (ZapiszDoPlikuPoKażdejZmianie) ZapiszDoPlikuXml();
        }
        public int Liczba
        {
            get
            {
                return wpisy.Count;
            }
        }
        public Wpis Pobierz(int indeks)
        {
            return wpisy[indeks];
        }        
        public Wpisy(string nazwaPlikuXml)
        {
            this.nazwaPlikuXml = nazwaPlikuXml;
            czytajZPlikuXml();
        }
    }
}