unit Shellage;

interface

uses Windows, SysUtils, Messages, ShellAPI, Classes, Graphics, Forms, Menus,
     StdCtrls, ExtCtrls;

type
  ENotifyIconError = class(Exception);

  TNotifyIcon = class(TComponent)
  private
    FDefaultIcon: THandle;
    FIcon: TIcon;
    FHideTask: Boolean;
    FHint: String;
    FIconVisible: Boolean;
    FInternalID: Cardinal;
    FParentWnd: hWnd;
    FPopupMenu: TPopupMenu;
    FOnClick: TNotifyEvent;
    FOnDblClick: TNotifyEvent;
    FNewWndProc: Pointer;
    FNoShowClick: Boolean;
    FOldOwnerWndProc: Pointer;
    FTimer: TTimer;
    FWndProcChanged: Boolean;
    Tnd: TNotifyIconData;
    procedure SetIcon(Value: TIcon);
    procedure SetHideTask(Value: Boolean);
    procedure SetHint(Value: String);
    procedure SetIconVisible(Value: Boolean);
    procedure SetPopupMenu(Value: TPopupMenu);
    procedure SendTrayMessage(Msg: DWORD; Flags: UINT);
    procedure OwnerWndProc(var Message: TMessage);
    function ActiveIconHandle: THandle;
    procedure OnButtonTimer(Sender: TObject);
  protected
    procedure Loaded; override;
    procedure LoadDefaultIcon; virtual;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    property Icon: TIcon read FIcon write SetIcon;
    property HideTask: Boolean read FHideTask write SetHideTask default False;
    property Hint: String read FHint write SetHint;
    property IconVisible: Boolean read FIconVisible write SetIconVisible default False;
    property PopupMenu: TPopupMenu read FPopupMenu write SetPopupMenu;
    property OnClick: TNotifyEvent read FOnClick write FOnClick;
    property OnDblClick: TNotifyEvent read FOnDblClick write FOnDblClick;
  end;

procedure Register;

var
  Tray_CallBack: UINT;

Procedure _Hook (var i: integer);

implementation

var
  IconCount: Cardinal = 0;

const
  { Identyfikacja okna komunikatu rejestracyjnego }
  Tray_CallBack_Str: PChar = 'DDG.TNotifyIconMsg';

constructor TNotifyIcon.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  { Waciciel musi by klasy TForm lub pochodnej }
  if not (AOwner is TForm) then
    raise ENotifyIconError.Create('Waciciel komponentu musi by formularzem');
  FParentWnd := TForm(AOwner).Handle;
  { Twrz now procedur okna formularza }
  FNewWndProc := MakeObjectInstance(OwnerWndProc);
  { Zastp star procedur okna }
  FOldOwnerWndProc := Pointer(SetWindowLong(FParentWnd, GWL_WNDPROC,
                              Longint(FNewWndProc)));
  { Generuj wyjtek przy niepowodzeniu zastpienia procedury komunikacyjnej }
  if FOldOwnerWndProc = Nil then
    raise ENotifyIconError.Create('Bd przedefiniowania procedury komunikacyjnej');
  FWndProcChanged := True;
  FIcon := TIcon.Create;
  FTimer := TTimer.Create(Self);
  with FTimer do begin
    Enabled := False;
    Interval := GetDoubleClickTime;
    OnTimer := OnButtonTimer;
  end;
  { Zachowaj domyln ikon }
  LoadDefaultIcon;
  { Uzyskaj unikalny identyfikator komunikatu }
  Tray_Callback := RegisterWindowMessage(Tray_Callback_Str);
  { Oblicz unikalny numer ikony }
  FInternalID := IconCount;
  inc(IconCount);
end;

destructor TNotifyIcon.Destroy;
begin
  { Zniszcz ikon }
  if FIconVisible then
    SetIconVisible(False);
  { Odtwrz poprzedni procedur komunikacyjn }
  if (FWndProcChanged) and (FNewWndProc <> Nil) then begin
    SetWindowLong(FParentWnd, GWL_WNDPROC, Longint(FOldOwnerWndProc));
    FreeObjectInstance(FNewWndProc);
  end;
  FIcon.Free;
  FTimer.Free;
  inherited Destroy;
end;

function TNotifyIcon.ActiveIconHandle: THandle;
{ Zwraca uchwyt aktywnej ikony }
begin
  { Jeeli nia zaadowano adnej ikony, zwr uchwyt ikony domylnej }
  if (FIcon.Handle <> 0) then
    Result := FIcon.Handle
  else
    Result := FDefaultIcon;
end;

procedure TNotifyIcon.LoadDefaultIcon;
{ Zaaduj domyln ikon. Jeeli waciwo "Icon" nie okrela adnej
  ikony, bdzie uywana wanie ta domylna.
}
begin
  FDefaultIcon := LoadIcon(0, IDI_WINLOGO);
end;

procedure TNotifyIcon.Loaded;
{ Ta metoda jest wywoywana gdy komponent jest odczytywany ze strumienia }
begin
  inherited Loaded;
  { Jeeli ikona ma by widoczna, utwrz j }
  if FIconVisible then
    SendTrayMessage(NIM_ADD, NIF_MESSAGE or NIF_ICON or NIF_TIP);
end;

procedure TNotifyIcon.OnButtonTimer(Sender: TObject);
{ Timer used to keep track of time between two clicks of a }
{ double click. This delays the first click long enough to }
{ ensure that a double click hasn't occurred.  The whole   }
{ point of these gymnastics is to allow the component to   }
{ receive OnClicks and OnDblClicks independently. }

{

  W Win32 API zdarzenie dwukrotnego kliknicia zawsze jest poprzedzone
  sygnalizacj kliknicia pojedynczego. Zegar uywany jest do upewnienia
  si, e dane kliknicie nie jest pierwszym z serii dwch klini,
  skadajcych si na dwukrotne kliknicie; jest to prawda, jeeli w
  czasie okrelonym przez interwa zegara po danym klikniciu nie
  zarejestrowano zdarzenia dwukrotnego kliknicia; ten ostatni fakt
  sygnalizowany jest przez flag FNoShowClick
}


begin
  { Ponisza instrukcja zabezpiecza przed wielokrotnym generowaniem
    zdarzenia kliknicia
  }
  FTimer.Enabled := False;
  { Jeeli nie zarejestrowano podwjnego kliknicia, generuj zdarzenie
    pojedynczego kliknicia
  }
  if (not FNoShowClick) and Assigned(FOnClick) then
    FOnClick(Self);
  FNoShowClick := False;
end;

procedure TNotifyIcon.OwnerWndProc(var Message: TMessage);
{
  Nowa procedura komunikacyjna okna formularza. Pozwala na przechwycenie
  komunikatw pochodzcych od ikony w podajniku.
}


var
  Pt: TPoint;
begin
  with Message do begin
    { jeli jest to komunikat z podajnika i dotyczy tej ikony ... }
    if (Msg = Tray_Callback) and (wParam = FInternalID) then begin
      case lParam of

        {
          Przy naciniciu lewego klawisza myszki uruchom zegar,
          wczajc tym samym czuwanie w nadziei wykrycia dwukrotnego
          kliknicia.
        }
        wm_LButtonDown   : FTimer.Enabled := True;


        { Zarejestruj dwukrotne kliknicie }
        wm_LButtonDblClk : begin
          FNoShowClick := True;
          if Assigned(FOnDblClick) then FOnDblClick(Self);
        end;


        wm_RButtonDown   : begin
          { Wywoanie procedury SetForegroundWindow wymagane przez API }
          SetForegroundWindow(FParentWnd);
          { Rozwi menu w miejscu kursora }
          GetCursorPos(Pt);
          if Assigned(FPopupMenu) then FPopupMenu.Popup(Pt.X, Pt.Y);
        end;
      end;
    end
    else
      {
        To nie jest komunikat z podajnika, wywoaj poprzedni
        procedur komunikacyjn.
      }
      Result := CallWindowProc(FOldOwnerWndProc, FParentWnd, Msg,
                               wParam, lParam);
  end;
end;

procedure TNotifyIcon.SendTrayMessage(Msg: DWORD; Flags: UINT);
{ Ta metoda wspomaga wywoanie funkcji API Shell_NotifyIcon }
begin
  { Wypenij rekord odpowiednimi wartociami }
  with Tnd do begin
    cbSize := SizeOf(Tnd);
    StrPLCopy(szTip, PChar(FHint), SizeOf(szTip));
    uFlags := Flags;
    uID := FInternalID;
    Wnd := FParentWnd;
    uCallbackMessage := Tray_Callback;
    hIcon  := ActiveIconHandle;
  end;
  Shell_NotifyIcon(Msg, @Tnd);
end;

procedure TNotifyIcon.SetIcon(Value: TIcon);
{ Metoda dostpowa waciwoci Icon }
begin
  FIcon.Assign(Value);  // stwrz now ikon
  if FIconVisible then
    { Zmie ikon w podajniku }
    SendTrayMessage(NIM_MODIFY, NIF_ICON);
end;

procedure TNotifyIcon.SetIconVisible(Value: Boolean);
{ Metoda dostpowa waciwoci IconVisible }
const
  { Flagi do dodawania i usuwania ikony w podajniku }
  MsgArray: array[Boolean] of DWORD = (NIM_DELETE, NIM_ADD);
begin
  if FIconVisible <> Value then begin
    FIconVisible := Value;
    SendTrayMessage(MsgArray[Value], NIF_MESSAGE or NIF_ICON or NIF_TIP);
  end;
end;

procedure TNotifyIcon.SetHideTask(Value: Boolean);
{ Metoda dostpowa waciwoci HideTask }
const
  { Flagi regulujce obecno/nieobecno aplikacji na pasku zada }
  ShowArray: array[Boolean] of integer = (sw_ShowNormal, sw_Hide);
begin
  if FHideTask <> Value then begin
    FHideTask := Value;
    { Nie rb nic w trakcie projektowania }
    if not (csDesigning in ComponentState) then
      ShowWindow(Application.Handle, ShowArray[FHideTask]);
  end;
end;

procedure TNotifyIcon.SetHint(Value: String);
{ Metoda dostpowa waciwoci Hint }
begin
  if FHint <> Value then begin
    FHint := Value;
    if FIconVisible then
      { Zmie podpowied towarzyszc ikonie w podajniku }
      SendTrayMessage(NIM_MODIFY, NIF_TIP);
  end;
end;

procedure TNotifyIcon.SetPopupMenu(Value: TPopupMenu);
{ Metoda dostpowa waciwociPopupMenu }
begin
  FPopupMenu := Value;
  if Value <> nil then Value.FreeNotification(Self);
end;

Procedure _Hook (var i: integer);
begin
  Inc(i);
end;



procedure Register;
begin
  RegisterComponents('DDG', [TNotifyIcon]);
end;

end.
