unit DemoFrm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  DiskChangeEx, StdCtrls;

type
  TfrmDemo = class(TForm)
    btnEnable: TButton;
    DiskChangeNotifyEx1: TDiskChangeNotifyEx;
    btnFiles: TButton;
    lblWatchDir: TLabel;
    procedure btnEnableClick(Sender: TObject);
    procedure DiskChangeNotifyEx1FilesChanged(Sender: TObject; NewFiles,
      DeletedFiles: TStringList);
    procedure DiskChangeNotifyEx1DiskChange(Sender: TObject);
    procedure btnFilesClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmDemo: TfrmDemo;

implementation

{$R *.DFM}

procedure TfrmDemo.btnEnableClick(Sender: TObject);
begin
  DiskChangeNotifyEx1.Enabled := not DiskChangeNotifyEx1.Enabled;
  btnFiles.Enabled := DiskChangeNotifyEx1.Enabled;
  if (DiskChangeNotifyEx1.Enabled) then begin
    btnEnable.Caption := 'Disable';
    lblWatchDir.Caption := 'Watching ' + DiskChangeNotifyEx1.WatchDir;
  end
  else begin
    btnEnable.Caption := 'Enable';
    lblWatchDir.Caption := '';
  end;
end;

procedure TfrmDemo.DiskChangeNotifyEx1FilesChanged(Sender: TObject; NewFiles, DeletedFiles: TStringList);
var
  TempStr : string;
  i : integer;
begin
  if (IsIconic (Application.Handle)) then Application.Restore;
  Application.BringToFront;
  BringToFront;

  TempStr := '';
  if (NewFiles.Count > 0) then begin
    TempStr := TempStr + 'New Files: ';
    for i := 0 to NewFiles.Count - 1 do
      TempStr := TempStr + NewFiles [i] +'; ';
    if (DeletedFiles.Count > 0) then
      TempStr := TempStr + #13#13;
  end;

  if (DeletedFiles.Count > 0) then begin
    TempStr := TempStr + 'Deleted Files: ';
    for i := 0 to DeletedFiles.Count - 1 do
      TempStr := TempStr + DeletedFiles [i] +'; ';
  end;

  ShowMessage (TempStr);
end;

procedure TfrmDemo.DiskChangeNotifyEx1DiskChange(Sender: TObject);
begin
  MessageBeep (0);
end;

procedure TfrmDemo.btnFilesClick(Sender: TObject);
var
  TempStr : string;
  i : integer;
begin
  if (DiskChangeNotifyEx1.Enabled) then begin
    while (DiskChangeNotifyEx1.Busy) do Application.ProcessMessages;

    TempStr := Format ('Files in directory %s : ', [DiskChangeNotifyEx1.WatchDir]);
    for i := 0 to DiskChangeNotifyEx1.CurrentDirList.Count - 1 do
      TempStr := TempStr + DiskChangeNotifyEx1.CurrentDirList [i] +'; ';
    ShowMessage (TempStr);
  end;  
end;

procedure TfrmDemo.FormShow(Sender: TObject);
begin
  lblWatchDir.Caption := '';
end;

end.

