//---------------------------------------------------------------------------
#ifndef LinkH
#define LinkH
//---------------------------------------------------------------------------
#include <vcl\SysUtils.hpp>
#include <vcl\Controls.hpp>
#include <vcl\Classes.hpp>
#include <vcl\Forms.hpp>
#include <vcl\StdCtrls.hpp>
//---------------------------------------------------------------------------

const Controls::TCursor crLink=1;
const Controls::TCursor crMail=2;

class PACKAGE TLink_base : public TCustomLabel //mod
{
private:
protected:
    void __fastcall ChangeColorActive(TObject* Sender,TMouseButton Button,Classes::TShiftState Shift,int X,int Y);
    void __fastcall ChangeColorInactive(TObject* Sender,TMouseButton Button,Classes::TShiftState Shift,int X,int Y);
    AnsiString FAddress;
	virtual void __fastcall CheckAddress(System::AnsiString)=0;

	//mod
    virtual void __fastcall SetColor(TColor);
    virtual void __fastcall SetDescription(System::AnsiString);

    //mod
    AnsiString FDescription;
    TColor FInactiveColor;
	TColor FActiveColor;
public:
	__fastcall TLink_base(TComponent* Owner);
    void __fastcall Connect(TObject* Sender);
__published:
    __property System::AnsiString Address = {read=FAddress, write=CheckAddress, nodefault};

	//mod
    __property Align;
    __property Enabled;
    __property Font;
    __property Transparent;
    __property Visible;


	//mod
    __property System::AnsiString Description = {read=FDescription, write=SetDescription, nodefault};
    __property TColor InactiveColor = {read=FInactiveColor, write=SetColor, nodefault};
    __property TColor ActiveColor = {read=FActiveColor, write=FActiveColor, nodefault};
	};

class PACKAGE TLink : public TLink_base
{
private:
	void __fastcall CheckAddress(System::AnsiString);
public:
	__fastcall TLink(TComponent* Owner);
};

//---------------------------------------------------------------------------
class PACKAGE TMail : public TLink_base
{
private:
	void __fastcall CheckAddress(System::AnsiString);
protected:
public:
	__fastcall TMail(TComponent* Owner);
__published:
};

//---------------------------------------------------------------------------
#endif
