using System;
using System.Collections.Generic;
using System.Text;

namespace HelloWorld
{
    /// <summary>
    /// Memory based <see cref="IRepository"/>
    /// </summary>
    public class MemoryRepository : IRepository
    {
        private static IRepository instance = new MemoryRepository();
        private List<object> repository = new List<object>();

        private MemoryRepository() { }

        #region IRepository Members

        /// <summary>
        /// Gets the instance.
        /// </summary>
        /// <returns></returns>
        public static IRepository GetInstance()
        {
            return instance;
        }

        public void AddObject(object obj)
        {
            this.repository.Add(obj);

        }

        public IList<object> GetAllObjects()
        {
            return this.repository.AsReadOnly();
        }

        #endregion
    }
}
