using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;

namespace HelloWorld.Tests
{
    [TestFixture]
    public class MemoryRepositoryTest
    {
        [Test]
        public void Simple()
        {
            IRepository repository = MemoryRepository.GetInstance();
            repository.AddObject(2);
            repository.AddObject("ala");
            repository.AddObject(this);

            Assert.AreEqual(6, repository.GetAllObjects().Count);
        }

        [Test]
        [ExpectedException(typeof(NotSupportedException))]
        public void Modification()
        {
            IRepository repository = MemoryRepository.GetInstance();
            repository.AddObject(2);
            repository.AddObject("ala");
            repository.AddObject(this);
            repository.GetAllObjects().Remove(this);

        }
    }
}
