using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace Pi
{
    public partial class Form1 : Form
    {
        Random random = new Random();
        ulong N = 0;
        double pi, dokladnosc;

        public Form1()
        {
            InitializeComponent();            
        }
        
        private void button1_Click(object sender, EventArgs e)
        {
            if (!backgroundWorker1.IsBusy)
            {
                if (backgroundWorker1.WorkerSupportsCancellation)
                    button1.Text = "Przerwij obliczenia";
                else
                    button1.Enabled = false;
                this.Cursor = Cursors.WaitCursor;
                button1.Cursor=Cursors.Default;
                backgroundWorker1.RunWorkerAsync();
            }
            else
            {
                if (backgroundWorker1.WorkerSupportsCancellation)
                    backgroundWorker1.CancelAsync();
            }
        }

        private void backgroundWorker1_DoWork(object sender, DoWorkEventArgs e)
        {
            //ulong maks_ilosc=ulong.MaxValue;
            ulong maks_ilosc=(ulong)1E8,co_ile_pokazywac=(ulong)1E6;
            int procent=0;
            double szereg=0;
            do
            {
                //obliczanie kolejnych wyrazow
                N++;
                szereg+=(1.0/(1.0*N*N));                
                if (backgroundWorker1.WorkerReportsProgress && N%co_ile_pokazywac==0)
                {
                    pi=Math.Sqrt(6*szereg);
                    dokladnosc=1/(double)N;
                    procent=(int)(100*((double)N/(double)maks_ilosc));
                    backgroundWorker1.ReportProgress(procent);
                }
            } while (N<maks_ilosc && !backgroundWorker1.CancellationPending);

            pi=Math.Sqrt(6*szereg);
            dokladnosc=1/(double)N;
            e.Result=pi;            
        }
   
        private void backgroundWorker1_RunWorkerCompleted(object sender, RunWorkerCompletedEventArgs e)
        {            
            //informacja o wynikach
            label4.Text=N.ToString();
            label5.Text=pi.ToString();
            label6.Text=dokladnosc.ToString();            

            //resetowanie obliczen
            N=0;
            
            //przywracanie pierwotnego stanu przycisku
            this.Cursor = Cursors.Default;
            if (backgroundWorker1.WorkerSupportsCancellation)
                button1.Text="Rozpocznij obliczenia";
            else
                button1.Enabled=true;            
        }

        private void backgroundWorker1_ProgressChanged(object sender, ProgressChangedEventArgs e)
        {
            //informacja o postepie obliczen
            progressBar1.Value=e.ProgressPercentage;
            label4.Text=N.ToString();
            label5.Text=pi.ToString();
            label6.Text=dokladnosc.ToString();
        }
    }
}