#if DEBUG
#warning Kompilacja wersji Debug
#else
#warning Kompilacja wersji Release
#endif

#define PRIORYTETY

#if PRIORYTETY //zdefiniowane w opcjach projektu
#warning Kompilacja wersji Priorytety
#endif


using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace Reversi
{
    public partial class Form1 : Form
    {
 		/// <summary>
		/// Required designer variable.
		/// </summary>		
		private ReversiSilnikAI silnik=null;
        private Button[,] plansza=null;
		private Color[] kolory={Color.Ivory, Color.Green, Color.Sienna, Color.Black};
        private bool plaskiInterfejs=false;
        private bool pokazPriorytety=false;
		private System.Windows.Forms.Panel panel1;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Button button1;
		private System.Windows.Forms.ListBox listBox1;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.ListBox listBox2;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.Label label4;
		private System.Windows.Forms.Label label5;
		private System.Windows.Forms.Label label6;
		private System.Windows.Forms.LinkLabel linkLabel1;
		private System.Windows.Forms.MainMenu mainMenu1;
		private System.Windows.Forms.MenuItem menuItem1;
		private System.Windows.Forms.MenuItem menuItem2;
		private System.Windows.Forms.MenuItem menuItem3;
		private System.Windows.Forms.MenuItem menuItem4;
		private System.Windows.Forms.MenuItem menuItem5;
		private System.Windows.Forms.MenuItem menuItem6;
		private System.Windows.Forms.MenuItem menuItem7;
		private System.Windows.Forms.MenuItem menuItem8;
		private System.Windows.Forms.MenuItem menuItem9;

		//komputer ma numer 2 i gra brzowymi
		private bool graPrzeciwkoKomputerowi=true;
		private System.Windows.Forms.MenuItem menuItem10;
		private System.Windows.Forms.Timer opozniaczRuchuKomputera;
		private System.Windows.Forms.MenuItem menuItem11;
		private System.Windows.Forms.MenuItem menuItem12;
		private System.Windows.Forms.MenuItem menuItem13;
		private System.Windows.Forms.MenuItem menuItem14;

        public Form1(string[] args)
		{            
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

            int planszaSzer=8;
            int planszaWys=8;

            //Parametry z linii polecen
			if (args!=null)
			{
				foreach (string argv in args)
				{
                    if (argv[0]=='/')
                    switch(argv[1])
                    {
                        case 'f': plaskiInterfejs=true; break;
                        case 'p': pokazPriorytety=true; break;
                        case 'w': planszaSzer=int.Parse(argv.Substring(2)); break;
                        case 'h': planszaWys=int.Parse(argv.Substring(2)); break;
                    }
				}
            }

            if ((planszaSzer<3) || (planszaWys<3))
            {
                MessageBox.Show("Podany rozmiar planszy "+planszaSzer+"x"+planszaWys+" jest zbyt may do gry.\nPrzywracam rozmiar domylny 8x8");
                planszaSzer=8;
                planszaWys=8;
            }

            //inicjacja pol zaleznych od rozmiaru planszy
            silnik=new ReversiSilnikAI(planszaSzer,planszaWys);
            plansza=new Button[silnik.planszaSzer,silnik.planszaWys];            
            
            if (plaskiInterfejs)
            {
                button1.FlatStyle=FlatStyle.Flat;
                menuStrip1.Visible=false;
                menuStrip1=null;
            }
            else
            {
                mainMenu1=null;
            }

			//ustalanie rozmiaru przycisku
			const int rozmiarPlanszy=400;
			int przyciskSzer=rozmiarPlanszy/silnik.planszaSzer;
			int przyciskWys=rozmiarPlanszy/silnik.planszaWys;

			//dopasowywanie okna do calkowitej ilosci przyciskow
            int wysokoscMenu=(menuStrip1!=null)?menuStrip1.Height:0;
			int roznicaSzer=przyciskSzer*silnik.planszaSzer-this.ClientSize.Width;
			int roznicaWys=przyciskWys*silnik.planszaWys-this.ClientSize.Height;
			this.Width+=roznicaSzer+panel1.Width+1;
            this.Height+=roznicaWys+1+wysokoscMenu;

            linkLabel1.Top=panel1.ClientSize.Height-linkLabel1.Height-10;

			for (int i=0; i<silnik.planszaSzer; i++)
				for (int j=0; j<silnik.planszaWys; j++)
					{
					Button pole=new Button();
                    pole.SetBounds(i*przyciskSzer,1+j*przyciskWys+wysokoscMenu,przyciskSzer,przyciskWys);
					pole.Parent=this;
                    if (plaskiInterfejs) pole.FlatStyle=FlatStyle.Flat;
					pole.Click+=new System.EventHandler(this.kliknieciePolaPlanszy);
					plansza[i,j]=pole;
					}

			uzgodnijWygladPlanszy();

			/*
			//test
			silnik.UstawPionek(2,4);
			uzgodnijWygladPlanszy();
			*/
			linkLabel1.Links.Add(0,linkLabel1.Text.Length,"http://www.phys.uni.torun.pl/~jacek");

			//przeniesione, zeby rozmiar formy byl dobrze ustalony
			this.Menu = this.mainMenu1;
		}

		#region Metody pomocnicze
		private void uzgodnijWygladPlanszy()
		{
			for (int i=0; i<silnik.planszaSzer; i++)
				for (int j=0; j<silnik.planszaWys; j++)
					{
					//plansza[i,j].Text=silnik.StanPola(i,j).ToString();
					//plansza[i,j].BackColor=kolory[silnik.StanPola(i,j)];
					plansza[i,j].BackColor=kolory[silnik[i,j]];
					#if PRIORYTETY
                    if (pokazPriorytety) plansza[i,j].Text="";
					#endif
					}

			//this.Text="Nastpny ruch gracz nr "+silnik.NumerGraczaWykonujacegoNastepnyRuch();
			button1.BackColor=kolory[silnik.NumerGraczaWykonujacegoNastepnyRuch()];
		}

		private void ustawieniePlanszyOdNowa()
		{
			silnik=new ReversiSilnikAI(silnik.planszaSzer,silnik.planszaWys); //stary obiekt zostanie automatycznie usuniety
			listBox1.Items.Clear();
			listBox2.Items.Clear();
			label5.Text="2";
			label6.Text="2";
			uzgodnijWygladPlanszy();
		}

		private void ruchKomputera()
		{
			int[] wspolrzedne=silnik.ProponujNajlepszyRuch();
			kliknieciePolaPlanszy(plansza[wspolrzedne[0],wspolrzedne[1]],null);
		}

		//************************************//
		// GWNA METODA "RZDZCA" PROGRAMEM //
		//************************************//
		private void kliknieciePolaPlanszy(object sender,EventArgs e)
		{
			//szukamy pola planszy odpowiadajcego kliknietemu przyciskowi
			int kliknietePoziomo=-1,kliknietePionowo=-1;
			for(int poziomo=0;poziomo<silnik.planszaSzer;poziomo++)
				for(int pionowo=0;pionowo<silnik.planszaWys;pionowo++)
					if (sender==plansza[poziomo,pionowo])
						{
						kliknietePoziomo=poziomo;
						kliknietePionowo=pionowo;
						}

			//jezeli nie znaleziony - zglaszanie bledu
			if (kliknietePoziomo==-1 || kliknietePionowo==-1)
				throw new Exception("Nie zidentyfikowane pole planszy");

			//wykonanie ruchu
			int zapamietanyNumerGracza=silnik.NumerGraczaWykonujacegoNastepnyRuch();
			if (silnik.UstawPionek(kliknietePoziomo,kliknietePionowo))
				{
				uzgodnijWygladPlanszy();
				//listBox1.Items.Add(""+zapamietanyNumerGracza+": "+kliknietePoziomo+", "+kliknietePionowo);
				switch(zapamietanyNumerGracza)
					{
					case 1: listBox1.Items.Add(ReversiSilnikAI.SymbolPola(kliknietePoziomo,kliknietePionowo)); break;
					case 2: listBox2.Items.Add(ReversiSilnikAI.SymbolPola(kliknietePoziomo,kliknietePionowo)); break;
					}
				listBox1.SelectedIndex=listBox1.Items.Count-1;
				listBox2.SelectedIndex=listBox2.Items.Count-1;
				}

			//sprawdzenie czy gra zakonczona
			int[] zliczenia=new int[3];
			int koniec_kod=silnik.CzyKoniec(zliczenia);
			label5.Text=zliczenia[1].ToString();
			label6.Text=zliczenia[2].ToString();
			if (koniec_kod==2) MessageBox.Show("Obaj gracze nie mog wykona ruchu");
			if (koniec_kod>0)
				{
				//informacja o wygranym
                    if (zliczenia[1]==zliczenia[2]) MessageBox.Show("Remis - obaj gracze zajli tak sam ilo pl","Reversi");
                    else MessageBox.Show("Wygra gracz "+((zliczenia[1]>zliczenia[2])?"zielony":"brzowy"),"Reversi");
				if (MessageBox.Show(this,"Czy rozpocz gr od nowa?","Reversi",MessageBoxButtons.YesNo,MessageBoxIcon.Question)==DialogResult.Yes)
					{
					//rozpoczecie gry od nowa
					ustawieniePlanszyOdNowa();
					}
					else
					{
					this.Close();
					}
				return;
				}


			//sprawdzenie czy kolejny gracz ma mozliwosc ruchu
			if (!silnik.CzyMozliwyRuch())
				{
				MessageBox.Show("Gracz "+((silnik.NumerGraczaWykonujacegoNastepnyRuch()==1)?"zielony":"brzowy")+" zmuszony jest do oddania ruchu");
				silnik.Pass();
				uzgodnijWygladPlanszy();
				//jezeli komputer, to nie powinno byc return
				//(komputer zawsze brzowy)
				if (!(graPrzeciwkoKomputerowi && silnik.NumerGraczaWykonujacegoNastepnyRuch()==2)) return;
				}

			//Ruch komputera (gracz nr 2)
			if (graPrzeciwkoKomputerowi && silnik.NumerGraczaWykonujacegoNastepnyRuch()==2)
				{
				opozniaczRuchuKomputera.Enabled=true; //tam jest wywolywany ruch komputera z jednosekundowym opoznieniem
				//ruchKomputera();
				}

             if (plaskiInterfejs)
             {
                button1.Enabled=true;
                button1.Focus();
                button1.Enabled=false;
             }
		}
		#endregion

		private void linkLabel1_LinkClicked(object sender, System.Windows.Forms.LinkLabelLinkClickedEventArgs e)
		{
			System.Diagnostics.Process.Start(e.Link.LinkData as string);
		}

		private void button1_Click(object sender, System.EventArgs e)
		{
			ruchKomputera();
		}

		private void menuItem7_Click(object sender, System.EventArgs e)
		{
			MessageBox.Show(
			"W grze Reversi gracze zajmuj na przemian pola planszy przejmujc przy tym wszystkie pola przeciwnika znajdujce si midzy nowo zajtym polem, a innymi polami gracza wykonujcego ruch. Celem gry jest zdobycie wikszej iloci pl ni przeciwnik.\n"+
			"Gracz moe zaj jedynie takie pole, ktre pozwoli mu przej przynajmniej jedno pole przeciwnika. Jeeli takiego pola nie ma, musi odda ruch. "+
			"Gra koczy si w momencie zajcia wszystkich pl lub gdy aden z graczy nie moe wykona ruchu.\n",
			"Reversi - Zasady gry");
		}

		private void menuItem14_Click(object sender, System.EventArgs e)
		{
			MessageBox.Show(
			"Komputer kieruje si nastpujcymi priorytetami (od najwyszego):\n"+
			"1. Ustawi pionek w rogu.\n"+
			"2. Unika ustawienia pionka tu przy rogu.\n"+
			"3. Ustawi pionek przy krawdzi planszy.\n"+
			"4. Unika ustawienia pionka w wierszu lub kolumnie oddalonej o jedno pole od krawdzi planszy.\n"+
			"5. Wybiera pole, w wyniku ktrego zdobyta zostanie najwiksza liczba pl przeciwnika.\n",
			"Reversi - Strategia komputera");
		}

		private void menuItem9_Click(object sender, System.EventArgs e)
		{
            MessageBox.Show("Reversi (wersja "+Application.ProductVersion+", kompilacja dla .NET 2.0)\n(c) Jacek Matulewski 2004, 2007\n\n"+
            "Parametry uruchomienia:\n\t/f - paski interfejs\n\t/p - tablica wag przy podpowiedzi ruchu    \n\t/wnnn - ilo pl w poziomie rwna jest nnn   \n\t/hnnn - ilo pl w pionie rwna jest nnn\n\n"+
            "Testy:\tKazimierz Matulewski\n\tMonika Pogodziska\n\nNajnowsz wersj mona pobra ze strony\nhttp://www.phys.uni.torun.pl/~jacek/download/    ","Reversi - Informacje o programie");
		}

		private void menuItem4_Click(object sender, System.EventArgs e)
		{
			Close();
		}

		private void menuItem2_Click(object sender, System.EventArgs e)
		{
			graPrzeciwkoKomputerowi=false;
			ustawieniePlanszyOdNowa();
			this.Text="Reversi - 2 graczy";
		}

		private void menuItem5_Click(object sender, System.EventArgs e)
		{
			graPrzeciwkoKomputerowi=true;
			ustawieniePlanszyOdNowa();
			this.Text="Reversi - 1 gracz";
		}

		private void menuItem10_Click(object sender, System.EventArgs e)
		{
			int[] wspolrzedne=silnik.ProponujNajlepszyRuch();

            Color kolorGracza=(silnik.NumerGraczaWykonujacegoNastepnyRuch()==1)?kolory[1]:kolory[2];
            Color kolorTla=kolory[0];

			#if PRIORYTETY
            if (pokazPriorytety)
            {
                int redP=(kolorGracza.R+3*kolorTla.R)/4;
                int greenP=(kolorGracza.G+3*kolorTla.G)/4;
                int blueP=(kolorGracza.B+3*kolorTla.B)/4;
                Color kolorMozliwychRuchow=Color.FromArgb(redP,greenP,blueP);

                for (int i=0;i<silnik.planszaSzer;i++)
                    for (int j=0;j<silnik.planszaWys;j++)
                    {
                        long priorytet=silnik.planszaPriorytety[i,j];
                        if (priorytet!=0)
                        {
                            plansza[i,j].Text=priorytet.ToString();
                            plansza[i,j].BackColor=kolorMozliwychRuchow;
                        }
                    }
            }
			#endif

			//kolorPodpowiedzi.
			int red=(kolorGracza.R+kolorTla.R)/2;
			int green=(kolorGracza.G+kolorTla.G)/2;
			int blue=(kolorGracza.B+kolorTla.B)/2;
			Color kolorPodpowiedzi=Color.FromArgb(red,green,blue);

			plansza[wspolrzedne[0],wspolrzedne[1]].BackColor=kolorPodpowiedzi;
		}

		private void opozniaczRuchuKomputera_Tick(object sender, System.EventArgs e)
		{
			opozniaczRuchuKomputera.Enabled=false;
			if (silnik.CzyKoniec(null)==0) ruchKomputera();
		}

		private void menuItem11_Click(object sender, System.EventArgs e)
		{
			if (opozniaczRuchuKomputera.Enabled) return;
			if (silnik.CzyKoniec(null)==0) ruchKomputera();
		}

		private void menuItem12_Click(object sender, System.EventArgs e)
		{
			graPrzeciwkoKomputerowi=true;
			ustawieniePlanszyOdNowa();
			this.Text="Reversi - 1 gracz";

			//Ruch wykonuje komputer
			silnik.Pass();
			this.ruchKomputera(); //oddaje pierwszy ruch komputerowi
		}

        private void Form1_FormClosed(object sender,FormClosedEventArgs e)
        {
            //dzieki temu nie ma efektu znikajacego menu
            this.Visible=false;
        }
    }
}