﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using JacekMatulewski.Util;

namespace ColorMapsDemo
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        enum UkladKolorow {None,RGB,HSB};
        UkladKolorow uzytyUkladKolorow;

        private void trackBar1_Scroll(object sender, EventArgs e)
        {
            //HSB
            uzytyUkladKolorow = UkladKolorow.HSB;
            panel1.BackColor = ColorMaps.FromHsb(trackBar1.Value, trackBar2.Value, trackBar3.Value);
        }

        private void trackBar4_Scroll(object sender, EventArgs e)
        {
            //RGB
            uzytyUkladKolorow = UkladKolorow.RGB;
            panel1.BackColor = Color.FromArgb(trackBar4.Value, trackBar5.Value, trackBar6.Value);
        }

        private void panel1_BackColorChanged(object sender, EventArgs e)
        {
            //Tuple sprawdzic GetHue i inne
            string opis = "";
            //opis += "HSB=[" + trackBar1.Value.ToString() + "," + trackBar2.Value.ToString() + "," + trackBar3.Value.ToString() + "], ";
            opis += "HSB=[" + ((byte)panel1.BackColor.GetHue()).ToString() + "," + ((byte)(255*panel1.BackColor.GetSaturation())).ToString() + "," + ((byte)(255*panel1.BackColor.GetBrightness())).ToString() + "], ";
            opis += "RGB=[" + panel1.BackColor.R.ToString() + "," + panel1.BackColor.G.ToString() + "," + panel1.BackColor.B.ToString() + "]";
            label3.Text = opis;

            if (uzytyUkladKolorow == UkladKolorow.HSB)
            {
                trackBar4.Value = panel1.BackColor.R;
                trackBar5.Value = panel1.BackColor.G;
                trackBar6.Value = panel1.BackColor.B;
            }

            if (uzytyUkladKolorow == UkladKolorow.RGB)
            {                
                trackBar1.Value = (int)(panel1.BackColor.GetHue());
                trackBar2.Value = (int)(trackBar2.Maximum * panel1.BackColor.GetSaturation());
                trackBar3.Value = (int)(trackBar3.Maximum * panel1.BackColor.GetBrightness());
            }

            uzytyUkladKolorow = UkladKolorow.None;
        }
    }
}
