﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace Choinka
{
    public partial class Form1 : Form
    {
        private Bitmap obraz = null;

        private bool czyPrzenoszenie = false;
        private Point miejsceZlapania = new Point(0,0);

        public Form1()
        {
            InitializeComponent();

            //Wczytywanie obrazu z pliku (ustawienie Build Action: None/Copy...: Copy if newer)
            //obraz = new Bitmap("Rysunek.bmp");
            //Wczytywanie obrazu z zasobów (ustawienie Build Action: Embedded Resource/Copy...: Do not copy)
            System.Reflection.Assembly assembly=System.Reflection.Assembly.GetExecutingAssembly();
            obraz = new Bitmap(assembly.GetManifestResourceStream("Choinka.Rysunek.bmp"));
            obraz.MakeTransparent(Color.Magenta);
            this.Bounds = new Rectangle(0, 0, obraz.Width, obraz.Height);
        }

        private void Form1_Paint(object sender, PaintEventArgs e)
        {
            e.Graphics.DrawImage(obraz, 0, 0);
        }

        private void zakończToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            double szybkoscZnikania = 0.005;
            for (; Opacity > 0; Opacity -= szybkoscZnikania) ;
        }

        private void oToolStripMenuItem_Click(object sender, EventArgs e)
        {
            MessageBox.Show("Choinka 2010\nJacek Matulewski\ne-mail: jacek@fizyka.umk.pl");
        }

        private void Form1_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.Escape) Close();
            if (e.KeyCode == Keys.Space)
            {                
                toolStripMenuItem2_Click(null,null);
            }
        }

        private void notifyIcon1_MouseClick(object sender, MouseEventArgs e)
        {
            switch (e.Button)
            {
                case MouseButtons.Left: notifyIcon1.ShowBalloonTip(3000); break;
                //case MouseButtons.Right: toolStripMenuItem2_Click(null, null); break;
            }
        }

        private void toolStripMenuItem2_Click(object sender, EventArgs e)
        {
            if (this.Visible)
            {
                this.Hide();
                toolStripMenuItem2.Text = "Przywróć";
            }
            else
            {
                this.Show();
                toolStripMenuItem2.Text = "Ukryj";
            }

        }

        private void Form1_MouseDown(object sender, MouseEventArgs e)
        {
            this.Cursor = Cursors.Hand;
            czyPrzenoszenie = true;
            miejsceZlapania = e.Location;
        }

        private void Form1_MouseMove(object sender, MouseEventArgs e)
        {
            if (czyPrzenoszenie == false) return;
            Point przesuniecie = e.Location.OdejmijOd(miejsceZlapania);
            Left += przesuniecie.X;
            Top += przesuniecie.Y;
        }

        private void Form1_MouseUp(object sender, MouseEventArgs e)
        {
            this.Cursor = Cursors.Default;
            czyPrzenoszenie = false;
        }

        int numerKlatki = 0;
        Point pozycjaGwiazdki = new Point(100, 100);
        Random r = new Random();

        private void timer1_Tick(object sender, EventArgs e)
        {
            numerKlatki++;
            if (numerKlatki > 20)
            {
                numerKlatki = 0;
                pozycjaGwiazdki = new Point(r.Next(this.Width), r.Next(this.Width));
                this.Refresh();
            }
            this.Text = numerKlatki.ToString();

            RysujGwiazdke();
        }

        private void RysujGwiazdke()
        {
            Graphics g=this.CreateGraphics();
            Pen pioro=Pens.Yellow;
            int rozmiar = numerKlatki;
            g.DrawLine(
                pioro, 
                pozycjaGwiazdki.X - rozmiar / 2, 
                pozycjaGwiazdki.Y - rozmiar / 2, 
                pozycjaGwiazdki.X + rozmiar / 2, 
                pozycjaGwiazdki.Y + rozmiar / 2);
            g.DrawLine(
                pioro,
                pozycjaGwiazdki.X + 1 - rozmiar / 2,
                pozycjaGwiazdki.Y - rozmiar / 2,
                pozycjaGwiazdki.X + 1 + rozmiar / 2,
                pozycjaGwiazdki.Y + rozmiar / 2);
            g.DrawLine(
                pioro,
                pozycjaGwiazdki.X - 1 - rozmiar / 2,
                pozycjaGwiazdki.Y - rozmiar / 2,
                pozycjaGwiazdki.X - 1 + rozmiar / 2,
                pozycjaGwiazdki.Y + rozmiar / 2);


            g.DrawLine(
                pioro, 
                pozycjaGwiazdki.X + rozmiar / 2, 
                pozycjaGwiazdki.Y - rozmiar / 2, 
                pozycjaGwiazdki.X - rozmiar / 2, 
                pozycjaGwiazdki.Y + rozmiar / 2);
            g.DrawLine(
                pioro,
                pozycjaGwiazdki.X + rozmiar / 2,
                pozycjaGwiazdki.Y+1 - rozmiar / 2,
                pozycjaGwiazdki.X - rozmiar / 2,
                pozycjaGwiazdki.Y+1 + rozmiar / 2);
            g.DrawLine(
                pioro,
                pozycjaGwiazdki.X + rozmiar / 2,
                pozycjaGwiazdki.Y - 1 - rozmiar / 2,
                pozycjaGwiazdki.X - rozmiar / 2,
                pozycjaGwiazdki.Y - 1 + rozmiar / 2);
        }
    }

    static class Rozszerzenie
    {
        public static Point OdejmijOd(this Point odejmna, Point odejmnik)
        {
            Point roznica = new Point();
            roznica.X = odejmna.X - odejmnik.X;
            roznica.Y = odejmna.Y - odejmnik.Y;
            return roznica;
        }
    }
}
