#define PRIORYTETY

/*
#if DEBUG
#warning Kompilacja wersji Debug
#else
#warning Kompilacja wersji Release
#endif

#if PRIORYTETY //zdefiniowane w opcjach projektu
#warning Kompilacja wersji Priorytety
#endif
*/


using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace Ataxx
{
    public partial class Form1 : Form
    {
 		/// <summary>
		/// Required designer variable.
		/// </summary>        
		private Button[,] plansza=null;
        private int ustawienieBlokow=1;
        private AtaxxSilnikAI silnik=null;
		private Color[] kolory={Color.Ivory, Color.LimeGreen, Color.SteelBlue, Color.Gray};
        private bool plaskiInterfejs=false;
		private System.Windows.Forms.Panel panel1;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Button button1;
		private System.Windows.Forms.ListBox listBox1;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.ListBox listBox2;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.Label label4;
		private System.Windows.Forms.Label label5;
		private System.Windows.Forms.Label label6;
		private System.Windows.Forms.LinkLabel linkLabel1;
		private System.Windows.Forms.MainMenu mainMenu1;
		private System.Windows.Forms.MenuItem menuItem1;
		private System.Windows.Forms.MenuItem menuItem2;
		private System.Windows.Forms.MenuItem menuItem3;
		private System.Windows.Forms.MenuItem menuItem4;
		private System.Windows.Forms.MenuItem menuItem5;
		private System.Windows.Forms.MenuItem menuItem6;
		private System.Windows.Forms.MenuItem menuItem7;
		private System.Windows.Forms.MenuItem menuItem8;
		private System.Windows.Forms.MenuItem menuItem9;

		//komputer ma numer 2 i gra blekitnymi
		private bool graPrzeciwkoKomputerowi=true;
        private byte poziomTrudnosci=2;
        private const byte najwyzszyPoziomTrudnosci=2;
		private System.Windows.Forms.MenuItem menuItem10;
		private System.Windows.Forms.Timer opozniaczRuchuKomputera;
		private System.Windows.Forms.MenuItem menuItem11;
		private System.Windows.Forms.MenuItem menuItem12;
		private System.Windows.Forms.MenuItem menuItem13;
		private System.Windows.Forms.MenuItem menuItem14;

        //podpowiedz
        //Image podpowiedz=new Icon("../../Podpowiedz.ico").ToBitmap();
        //Image podpowiedz=new Bitmap("../../Podpowiedz.gif");
        Image podpowiedz=Properties.Resources.Podpowiedz;

        public Form1(string[] args)
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

            int planszaSzer=7;
            int planszaWys=7;

            //Parametry z linii polecen
            if (args!=null)
            {
                foreach (string argv in args)
                {
                    if (argv[0]=='/')
                        switch (argv[1])
                        {
                            case 'f': plaskiInterfejs=true; break;
                            case 'b': ustawienieBlokow=int.Parse(argv.Substring(2)); break;
                            case 'l': poziomTrudnosci=byte.Parse(argv.Substring(2)); break;
                            case 'w': planszaSzer=int.Parse(argv.Substring(2)); break;
                            case 'h': planszaWys=int.Parse(argv.Substring(2)); break;
                        }
                }
            }

            if ((planszaSzer<5)||(planszaWys<5))
            {
                MessageBox.Show("Podany rozmiar planszy "+planszaSzer+"x"+planszaWys+" jest zbyt may do gry.\nPrzywracam rozmiar domylny 7x7");
                planszaSzer=7;
                planszaWys=7;
            }

            //inicjacja pol, ktore nie mogly byc zainicjowane wczesniej
            silnik=new AtaxxSilnikAI(planszaSzer,planszaWys,ustawienieBlokow);
            plansza=new Button[silnik.planszaSzer,silnik.planszaWys];

            if (plaskiInterfejs)
            {
                button1.FlatStyle=FlatStyle.Flat;
                //menuStrip1.Visible=false;
                //menuStrip1=null;
            }
            else
            {
                //mainMenu1=null;
            }

			//ustalanie rozmiaru przycisku
			const int rozmiarPlanszy=400;
			int przyciskSzer=rozmiarPlanszy/silnik.planszaSzer;
			int przyciskWys=rozmiarPlanszy/silnik.planszaWys;

			//dopasowywanie okna do calkowitej ilosci przyciskow
			int roznicaSzer=przyciskSzer*silnik.planszaSzer-this.ClientSize.Width;
			int roznicaWys=przyciskWys*silnik.planszaWys-this.ClientSize.Height;
			this.Width+=roznicaSzer+panel1.Width+1;
			this.Height+=roznicaWys+1;

            linkLabel1.Top=panel1.ClientSize.Height-linkLabel1.Height-10;

			for (int i=0; i<silnik.planszaSzer; i++)
				for (int j=0; j<silnik.planszaWys; j++)
					{
					Button pole=new Button();
					pole.SetBounds(i*przyciskSzer,1+j*przyciskWys,przyciskSzer,przyciskWys);
					pole.Parent=this;
                    if (plaskiInterfejs) pole.FlatStyle=FlatStyle.Flat;
					pole.Click+=new System.EventHandler(this.kliknieciePolaPlanszy);
					plansza[i,j]=pole;
					}

			uzgodnijWygladPlanszy();

			/*
			//test
			silnik.UstawPionek(2,4);
			uzgodnijWygladPlanszy();
			*/
			linkLabel1.Links.Add(0,linkLabel1.Text.Length,"http://www.fizyka.umk.pl/~jacek");

			//przeniesione, zeby rozmiar formy byl dobrze ustalony
			this.Menu = this.mainMenu1;

            //1 gracz
            Text="Ataxx - 1 gracz (poziom trudnoci "+poziomTrudnosci.ToString()+")";

            //2 graczy
            //menuItem2_Click(null,null);
		}

		#region Metody pomocnicze
		private void uzgodnijWygladPlanszy()
		{
			for (int i=0; i<silnik.planszaSzer; i++)
				for (int j=0; j<silnik.planszaWys; j++)
				{
                    plansza[i,j].Image=null;
					//plansza[i,j].Text=silnik.StanPola(i,j).ToString();
					//plansza[i,j].BackColor=kolory[silnik.StanPola(i,j)];
					plansza[i,j].BackColor=kolory[silnik[i,j]];
                    plansza[i,j].Enabled=(silnik[i,j]!=3); //bloki sa nieaktywne
					#if PRIORYTETY
					plansza[i,j].Text="";
					#endif
				}

			//this.Text="Nastpny ruch gracz nr "+silnik.NumerGraczaWykonujacegoNastepnyRuch();
			button1.BackColor=kolory[silnik.NumerGraczaWykonujacegoNastepnyRuch()];
		}

		private void ustawieniePlanszyOdNowa()
		{
			silnik=new AtaxxSilnikAI(silnik.planszaSzer,silnik.planszaWys,ustawienieBlokow); //stary obiekt zostanie automatycznie usuniety
			listBox1.Items.Clear();
			listBox2.Items.Clear();
			label5.Text="2";
			label6.Text="2";
			uzgodnijWygladPlanszy();
		}

		private void ruchKomputera()
		{
			int[] wspolrzedne=silnik.ProponujNajlepszyRuch(false,poziomTrudnosci);
            //czesciowa kopia case 1 z kliknieciePolaPlanszy
            int zapamietanyNumerGracza=silnik.NumerGraczaWykonujacegoNastepnyRuch();
            int rodzajRuchu=silnik.UstawPionek(wspolrzedne[0],wspolrzedne[1],wspolrzedne[2],wspolrzedne[3]);
            if (rodzajRuchu>0)
            {
                uzgodnijWygladPlanszy();
                string symbolRuchu=(rodzajRuchu==1)?" + ":" -> ";
                switch (zapamietanyNumerGracza)
                {
                    case 1: listBox1.Items.Add(AtaxxSilnikAI.SymbolPola(wspolrzedne[2],wspolrzedne[3])+symbolRuchu+AtaxxSilnikAI.SymbolPola(wspolrzedne[0],wspolrzedne[1])); break;
                    case 2: listBox2.Items.Add(AtaxxSilnikAI.SymbolPola(wspolrzedne[2],wspolrzedne[3])+symbolRuchu+AtaxxSilnikAI.SymbolPola(wspolrzedne[0],wspolrzedne[1])); break;
                }
                listBox1.SelectedIndex=listBox1.Items.Count-1;
                listBox2.SelectedIndex=listBox2.Items.Count-1;

                if (CzyKoniec()) return;
                if (!CzyMozliwyRuch()) opozniaczRuchuKomputera.Enabled=true;
            }
            else new Exception("Komputer zaproponowa niewaciwy ruch");
		}

		//************************************//
		// GWNA METODA "RZDZCA" PROGRAMEM //
		//************************************//
        private int fazaRuchu=0;
        private int wyznaczonePolePoziomo=-1;
        private int wyznaczonePolePionowo=-1;

        private bool CzyKoniec()
        {
            int[] zliczenia=new int[4];
            int koniec_kod=silnik.CzyKoniec(zliczenia);
            label5.Text=zliczenia[1].ToString();
            label6.Text=zliczenia[2].ToString();
            switch (koniec_kod)
            {
                case 1: MessageBox.Show("Wygra gracz zielony","Ataxx"); break;
                case 2: MessageBox.Show("Wygra gracz bkitny","Ataxx"); break;
                case 3: MessageBox.Show("Remis","Ataxx"); break;
            }
            if (koniec_kod>0)
            {
                if (MessageBox.Show(this,"Czy rozpocz gr od nowa?","Ataxx",MessageBoxButtons.YesNo,MessageBoxIcon.Question)==DialogResult.Yes)
                {
                    //rozpoczecie gry od nowa
                    ustawieniePlanszyOdNowa();
                }
                else
                {
                    this.Close();
                }
            }
            return koniec_kod>0;
        }

        private bool CzyMozliwyRuch()
        {
            if (!silnik.CzyMozliwyRuch())
            {
                MessageBox.Show("Gracz "+((silnik.NumerGraczaWykonujacegoNastepnyRuch()==1)?"zielony":"bkitny")+" zmuszony jest do oddania ruchu");
                silnik.Pass();
                uzgodnijWygladPlanszy();
                //jezeli komputer, to nie powinno byc return
                //(komputer zawsze blekitny)
                return false;
            }
            else return true;
        }

		private void kliknieciePolaPlanszy(object sender,EventArgs e)
		{
			//szukamy pola planszy odpowiadajcego kliknietemu przyciskowi
			int kliknietePoziomo=-1,kliknietePionowo=-1;
			for(int poziomo=0;poziomo<silnik.planszaSzer;poziomo++)
				for(int pionowo=0;pionowo<silnik.planszaWys;pionowo++)
					if (sender==plansza[poziomo,pionowo])
						{
						kliknietePoziomo=poziomo;
						kliknietePionowo=pionowo;
						}

			//jezeli nie znaleziony - zglaszanie bledu
			if ((kliknietePoziomo==-1) || (kliknietePionowo==-1))
				throw new Exception("Nie zidentyfikowane pole planszy");

            jeszczeraz:

            switch (fazaRuchu)
            {
                case 0:
                    //pierwsze klikniecie - wyznaczanie mozliwych ruchow
                    //Button kliknietePole=plansza[kliknietePoziomo,kliknietePionowo]
                    if (silnik.StanPola(kliknietePoziomo,kliknietePionowo)!=silnik.NumerGraczaWykonujacegoNastepnyRuch()) return;

                    fazaRuchu=1;
                    wyznaczonePolePoziomo=kliknietePoziomo;
                    wyznaczonePolePionowo=kliknietePionowo;

                    Color kolorGracza=(silnik.NumerGraczaWykonujacegoNastepnyRuch()==1)?kolory[1]:kolory[2];
                    Color kolorTla=kolory[0];
                    int red=(kolorGracza.R+kolorTla.R)/2;
                    int green=(kolorGracza.G+kolorTla.G)/2;
                    int blue=(kolorGracza.B+kolorTla.B)/2;
                    Color kolorMozliwy=Color.FromArgb(red,green,blue);
                    int xmin=Math.Max(kliknietePoziomo-2,0);
                    int xmax=Math.Min(kliknietePoziomo+2,silnik.planszaSzer-1);
                    int ymin=Math.Max(kliknietePionowo-2,0);
                    int ymax=Math.Min(kliknietePionowo+2,silnik.planszaWys-1);
                    for (int x=xmin;x<=xmax;x++)
                        for (int y=ymin;y<=ymax;y++)
                        {
                            if (silnik.StanPola(x,y)!=0) continue;
                            plansza[x,y].BackColor=kolorMozliwy;
                        }
                    return;
                    //break;

                case 1:
                    //drugie klikniecie - wykonanie ruchu lub odwolanie zaznaczenia                    
                    int zapamietanyNumerGracza=silnik.NumerGraczaWykonujacegoNastepnyRuch();
                    int rodzajRuchu=silnik.UstawPionek(kliknietePoziomo,kliknietePionowo,wyznaczonePolePoziomo,wyznaczonePolePionowo);
                    if (rodzajRuchu>0)
                    {
                        uzgodnijWygladPlanszy();
                        string symbolRuchu=(rodzajRuchu==1)?" + ":" -> ";
                        switch (zapamietanyNumerGracza)
                        {
                            case 1: listBox1.Items.Add(AtaxxSilnikAI.SymbolPola(wyznaczonePolePoziomo,wyznaczonePolePionowo)+symbolRuchu+AtaxxSilnikAI.SymbolPola(kliknietePoziomo,kliknietePionowo)); break;
                            case 2: listBox2.Items.Add(AtaxxSilnikAI.SymbolPola(wyznaczonePolePoziomo,wyznaczonePolePionowo)+symbolRuchu+AtaxxSilnikAI.SymbolPola(kliknietePoziomo,kliknietePionowo)); break;
                        }
                        listBox1.SelectedIndex=listBox1.Items.Count-1;
                        listBox2.SelectedIndex=listBox2.Items.Count-1;
                        fazaRuchu=0;                        
                    }
                    else
                    {
                        uzgodnijWygladPlanszy();
                        fazaRuchu=0;
                        goto jeszczeraz;
                    }
                    break;

                default:
                    MessageBox.Show("Bd!");
                    fazaRuchu=0;
                    uzgodnijWygladPlanszy();
                    break;
            }

			//sprawdzenie czy gra zakonczona
            if (CzyKoniec()) return;

			//sprawdzenie czy kolejny gracz ma mozliwosc ruchu
			if (!CzyMozliwyRuch())
				if (!(graPrzeciwkoKomputerowi && (silnik.NumerGraczaWykonujacegoNastepnyRuch()==2))) return;

			//Ruch komputera (gracz nr 2)
			if (graPrzeciwkoKomputerowi && (silnik.NumerGraczaWykonujacegoNastepnyRuch()==2))
			{
				opozniaczRuchuKomputera.Enabled=true; //tam jest wywolywany ruch komputera z jednosekundowym opoznieniem
				//ruchKomputera();
			}

            if (plaskiInterfejs)
            {
                button1.Enabled=true;
                button1.Focus();
                button1.Enabled=false;
            }
		}
		#endregion

		private void linkLabel1_LinkClicked(object sender, System.Windows.Forms.LinkLabelLinkClickedEventArgs e)
		{
			System.Diagnostics.Process.Start(e.Link.LinkData as string);
		}

		private void button1_Click(object sender, System.EventArgs e)
		{
			ruchKomputera();
		}

		private void menuItem7_Click(object sender, System.EventArgs e)
		{
			MessageBox.Show(            
            "Piony mog by poruszane w dowolnych kierunkach o nie wicej ni dwa pola.\n"+
            "Przesunicie o dwa pola oznacza przeskok piona, o jedno - tworzenie kolonii.\n"+
            "Ruch rozpoczyna si od wskazania piona, ktry ma by poruszony. Wwczas\n"+
            "na planszy zaznaczone zostan wszystkie jego moliwe ruchy - naley wybra\n"+
            "jeden z nich. Gr rozpoczyna zawsze gracz zielony. Jeeli w bezporednim\n"+
            "otoczeniu nowej pozycji piona le piony przeciwnika, wszystkie zostaj przejte\n"+
            "Celem gry jest przejcie wszystkich pionw przeciwnika, a przynajmniej zdobycie    \n"+
            "przewagi w momencie obsadzenia wszystkich pl.",
			"Ataxx - Zasady gry");
		}

		private void menuItem14_Click(object sender, System.EventArgs e)
		{
			MessageBox.Show(
			"Komputer kieruje si nastpujcymi priorytetami (od najwyszego):\n"+
			"1. Zaj pole-dziur (otoczone przez inne piony lub bloki).\n"+
			"2. Unika tworzenia pl-dziur (przez przeskok lub przez zajcie dziur stworzonych z dwch pl).\n"+
			"3. Przej jak najwicej pl przeciwnika.\n"+
			"4. Rozbudowywa koloni.\n",
			"Ataxx - Strategia komputera");
		}

		private void menuItem9_Click(object sender, System.EventArgs e)
		{
            MessageBox.Show("Ataxx (wersja "+Application.ProductVersion+")\n"+
                "(c) Jacek Matulewski 2007\n\n"+
                "Parametry uruchomienia:\n\t/f - paski interfejs\n\t/wnnn - ilo pl w poziomie rwna jest nnn   \n\t/hnnn - ilo pl w pionie rwna jest nnn"+
                "\n\t/bnnn - numer zestawu blokw\n\t/lnnn - poziom trudnosci\n\n"+
                "Testy:\tKazimierz Matulewski\n\nNajnowsz wersj mona pobra ze strony\nhttp://www.phys.uni.torun.pl/~jacek/download/     ","Ataxx - Informacje o programie");
		}

		private void menuItem4_Click(object sender, System.EventArgs e)
		{
			Close();
		}

		private void menuItem2_Click(object sender, System.EventArgs e)
		{
			graPrzeciwkoKomputerowi=false;
			ustawieniePlanszyOdNowa();
			this.Text="Ataxx - 2 graczy";
		}

		private void menuItem5_Click(object sender, System.EventArgs e)
		{
			graPrzeciwkoKomputerowi=true;
			ustawieniePlanszyOdNowa();
            this.Text="Ataxx - 1 gracz (poziom trudnoci "+poziomTrudnosci.ToString()+")";
		}

		private void menuItem10_Click(object sender, System.EventArgs e)
		{
			int[] wspolrzedne=silnik.ProponujNajlepszyRuch(false,najwyzszyPoziomTrudnosci);
            //plansza[wspolrzedne[0],wspolrzedne[1]].Text="Tu";
            //plansza[wspolrzedne[2],wspolrzedne[3]].Text="Std";
            plansza[wspolrzedne[0],wspolrzedne[1]].Image=podpowiedz;
            plansza[wspolrzedne[2],wspolrzedne[3]].Image=podpowiedz;
            //silnik.ProponujNajlepszyRuch(true,najwyzszyPoziomTrudnosci);         
		}

		private void opozniaczRuchuKomputera_Tick(object sender, System.EventArgs e)
		{
			opozniaczRuchuKomputera.Enabled=false;
			if (silnik.CzyKoniec(null)==0) ruchKomputera();            
		}

		private void menuItem11_Click(object sender, System.EventArgs e)
		{
			if (opozniaczRuchuKomputera.Enabled) return;
			if (silnik.CzyKoniec(null)==0) ruchKomputera();
            if (graPrzeciwkoKomputerowi && (silnik.NumerGraczaWykonujacegoNastepnyRuch()==2))
            {
                opozniaczRuchuKomputera.Enabled=true; //tam jest wywolywany ruch komputera z jednosekundowym opoznieniem
                //ruchKomputera();
            }
		}

		private void menuItem12_Click(object sender, System.EventArgs e)
		{
			graPrzeciwkoKomputerowi=true;
			ustawieniePlanszyOdNowa();
            this.Text="Ataxx - 1 gracz trudnoci (poziom "+poziomTrudnosci.ToString()+")";

			//Ruch wykonuje komputer
			silnik.Pass();
			ruchKomputera(); //oddaje pierwszy ruch komputerowi
		}

        private void zmianaPoziomuTrudnosci(object sender,EventArgs e)
        {
            menuItem16.Checked=menuItem17.Checked=menuItem18.Checked=false;
            (sender as MenuItem).Checked=true;
            if (sender==menuItem16) poziomTrudnosci=0;
            if (sender==menuItem17) poziomTrudnosci=1;
            if (sender==menuItem18) poziomTrudnosci=2;
            //MessageBox.Show("Poziom trudnoci zmieniony na "+poziomTrudnosci);
            if (graPrzeciwkoKomputerowi) this.Text="Ataxx - 1 gracz (poziom trudnoci "+poziomTrudnosci.ToString()+")";
        }

        private void zmianaUstawieniaBlokow(object sender,EventArgs e)
        {
            menuItem21.Checked=menuItem22.Checked=false;
            (sender as MenuItem).Checked=true;
            if (sender==menuItem21) ustawienieBlokow=0;
            if (sender==menuItem22) ustawienieBlokow=1;
            ustawieniePlanszyOdNowa();
        }

        private void Form1_FormClosed(object sender,FormClosedEventArgs e)
        {
            //dzieki temu nie ma efektu znikajacego menu
            this.Visible=false;
        }
    }
}