﻿using SpamClassifier.Core.Services;
using Xunit;

namespace SpamClassifier.Tests;

public class SmsSpamClassifierTests
{
    private readonly SmsSpamClassifierService _classifier;

    public SmsSpamClassifierTests()
    {
        _classifier = new SmsSpamClassifierService();

        var dataPath = Path.Combine(
            AppContext.BaseDirectory,
            "Data",
            "spam_or_not_spam_sms.csv");

        _classifier.Train(dataPath);
    }

    [Fact]
    public void Predict_SmsSpam_ReturnsSpam()
    {
        // Arrange
        var spamSms = "WINNER!! Claim your FREE prize now by calling 09061701461";

        // Act
        var result = _classifier.Predict(spamSms);

        // Assert
        Assert.True(result.IsSpam);
    }

    [Fact]
    public void Predict_SmsHam_ReturnsNotSpam()
    {
        // Arrange
        var hamSms = "Hey, are we still meeting today at 6?";

        // Act
        var result = _classifier.Predict(hamSms);

        // Assert
        Assert.False(result.IsSpam);
    }
}
