﻿using SpamClassifier.Core.Abstractions;
using SpamClassifier.Core.Services;

namespace SpamClassifier.ConsoleApp
{
    internal class Program
    {
        static void Main(string[] args)
        {
            Console.WriteLine("=== SpamClassifier ===");
            Console.WriteLine("Choose classifier type:");
            Console.WriteLine("1 - Email");
            Console.WriteLine("2 - SMS");
            Console.Write("Your choice: ");

            var choice = Console.ReadLine();

            ISpamClassifier? classifier = null;
            string? dataFileName = null;

            switch (choice)
            {
                case "1":
                    classifier = new MailSpamClassifierService();
                    dataFileName = "spam_or_not_spam.csv";
                    Console.WriteLine("Email spam classifier selected.");
                    break;

                case "2":
                    classifier = new SmsSpamClassifierService();
                    dataFileName = "spam_or_not_spam_sms.csv";
                    Console.WriteLine("SMS spam classifier selected.");
                    break;

                default:
                    Console.WriteLine("Invalid choice. Exiting...");
                    return;
            }

            var dataPath = Path.Combine(
                AppContext.BaseDirectory,
                "Data",
                dataFileName);

            Console.WriteLine();
            Console.WriteLine("Training model...");
            classifier.Train(dataPath);

            Console.WriteLine();
            Console.WriteLine("Model ready.");
            Console.WriteLine("Enter text to classify (empty line = exit).");
            Console.WriteLine();

            while (true)
            {
                Console.Write("Message> ");
                var input = Console.ReadLine();

                if (string.IsNullOrWhiteSpace(input))
                {
                    Console.WriteLine("Exiting...");
                    break;
                }

                var prediction = classifier.Predict(input);

                Console.WriteLine($"IsSpam: {prediction.IsSpam}");
                Console.WriteLine($"Probability: {prediction.Probability:0.000}");
                Console.WriteLine();
            }

            Console.WriteLine("Done.");
        }
    }
}
