﻿namespace ProgramowanieRównoległe
{
    internal class Program
    {
        #region Parallel.For
        private static double obliczenia(double argument, int n = 100)
        {
            for (int i = 0; i < n; i++)
            {
                argument = Math.Sin(Math.Asin(argument));
            }
            return argument;
        }

        static void Main1(string[] args)
        {
            int rozmiar = 10000;
            Random r = new Random();
            double[] tablica = new double[rozmiar];
            for (int i = 0; i < tablica.Length; i++) tablica[i] = r.NextDouble();

            //sekwencyjne
            int liczbaPowtórzeń = 1000;
            double[] wyniki = new double[tablica.Length];
            long start = Environment.TickCount64;
            /*
            for(int powtórzenie = 0; powtórzenie < liczbaPowtórzeń; powtórzenie++)
                for(int i = 0; i < tablica.Length; ++i)
                    wyniki[i] = obliczenia(tablica[i]);
            */
            long stop = Environment.TickCount64;
            //Console.WriteLine($"Czas obliczeń sekwencyjnych: {(stop - start)} ms");

            //równoległe
            start = Environment.TickCount64;
            for (int powtórzenie = 0; powtórzenie < liczbaPowtórzeń; powtórzenie++)
                //for (int i = 0; i < tablica.Length; ++i)
                Parallel.For(0, tablica.Length,
                    (int i, ParallelLoopState pls) =>
                    {
                        if (i == 100) pls.Stop();

                        if (pls.IsStopped) return;
                        wyniki[i] = obliczenia(tablica[i]);                        
                    });
            stop = Environment.TickCount64;
            Console.WriteLine($"Czas obliczeń równoległych: {(stop - start)} ms");
        }
        #endregion

        public static void ConsoleWriteLine(string s)
        {
            Console.WriteLine(s + ", wątek: " + Thread.CurrentThread.ManagedThreadId + ", zadanie: " + Task.CurrentId);
        }

        static Task<long> ZróbCośWZadaniu(object argument)
        {
            //KOPIA KODU!!!
            Func<object?, long> akcja =
                (object? argument) =>
                {
                    ConsoleWriteLine("Początek działania akcji");
                    Thread.Sleep(500);
                    ConsoleWriteLine("Koniec działania akcji");
                    return DateTime.Now.Ticks;
                };

            ConsoleWriteLine("ZróbCośWZadaniu - początek");
            Task<long> zadanie = new Task<long>(akcja, "zadanie");
            zadanie.Start();                        
            ConsoleWriteLine("ZróbCośWZadaniu - koniec");
            return zadanie;
        }

        private async static void programowanieAsynchroniczne()
        {
            Func<object?, long> akcja =
                (object? argument) =>
                {
                    ConsoleWriteLine("Początek działania akcji");
                    Thread.Sleep(500);
                    ConsoleWriteLine("Koniec działania akcji");
                    return DateTime.Now.Ticks;
                };

            ConsoleWriteLine("Synchronicznie - początek");
            long wynik = akcja("synchronicznie");
            ConsoleWriteLine("Synchronicznie - koniec");

            ConsoleWriteLine("-----------------");

            ConsoleWriteLine("Zadanie - początek");
            Task<long> zadanie = new Task<long>(akcja, "zadanie");
            zadanie.Start();
            //zadanie.Wait();            
            wynik = zadanie.Result; //punkt synchronizacji
            ConsoleWriteLine("Zadanie - koniec");

            ConsoleWriteLine("-----------------");

            ConsoleWriteLine("Funkcja - początek");
            wynik = ZróbCośWZadaniu("funkcja").Result;
            ConsoleWriteLine("Funkcja - koniec");

            ConsoleWriteLine("-----------------");

            ConsoleWriteLine("Await - początek");
            wynik = await ZróbCośWZadaniu("await");
            ConsoleWriteLine("Await - koniec");
        }

        static void Main(string[] args)
        {
            programowanieAsynchroniczne();

            ConsoleWriteLine("Naciśnij ENTER...");
            Console.ReadLine();
        }
    }
}
