using BibliotekaTuringa;
using System.Net.Http.Headers;

namespace TestyJednostkoweTuring
{
    [TestClass]
    public class TestTuring
    {
        //zapisy tam bez bdw
        string zapisTamy1 = "ABCdEFGH"; 
        string zapisTamy2 = "aBCDEFGH";

        /*
        //bdne
        string zapisTamy3 = "ABCDEFGh";
        string zapisTamy4 = "ABCDEFGH";
        string zapisTamy5 = "AbCdEFGH";
        string zapisTamy6 = "";
        string zapisTamy7 = "a";
        */

        //stany maszyny

        //program poprawny
        string[] program1 = { "qABq", "qBRs", "sBCd" };

        //niepoprawne programy
        string[] program2 = { "qAAq", "qBRs", "sBCd" };
        string[] program3 = { "qABq", "qARs", "sBCd" };
        string[] program4 = { };
        string[] program5 = { "qAbq", "qARs", "sBCd" };
        string[] program6 = { "QABq", "qARs", "sBCd" };
        string[] program7 = { "QABCq", "qARs", "sBCd" };

        [TestMethod]
        public void TestParsujZapisTamy1()
        {
            var stanMaszyny = Turing.ParsujZapisTamy(zapisTamy1);

            CollectionAssert.AreEqual(stanMaszyny.tama, "ABCEFGH".ToArray());
            //Assert.AreEqual(stanMaszyny.tama.ToString(), "ABCEFGH");
            Assert.AreEqual(stanMaszyny.stanGowicy, 'd');
            Assert.AreEqual(stanMaszyny.pooenieGowicy, 3);
        }

        [TestMethod]
        public void TestParsujZapisTamy2()
        {
            var stanMaszyny = Turing.ParsujZapisTamy(zapisTamy2);

            CollectionAssert.AreEqual(stanMaszyny.tama, "BCDEFGH".ToArray());
            Assert.AreEqual(stanMaszyny.stanGowicy, 'a');
            Assert.AreEqual(stanMaszyny.pooenieGowicy, 0);
        }

        [TestMethod]
        public void TestSprawdProgramPoprawny()
        {
            Turing.SprawdProgram(program1); //TODO: jak zrobi to mdrzej
        }

        [TestMethod]
        [ExpectedException(typeof(TuringException))]
        public void TestSprawdProgramNiepoprawny2()
        {
            Turing.SprawdProgram(program2);
        }

        [TestMethod]
        [ExpectedException(typeof(TuringException))]
        public void TestSprawdProgramNiepoprawny3()
        {
            Turing.SprawdProgram(program3);
        }

        [TestMethod]
        [ExpectedException(typeof(TuringException))]
        public void TestSprawdProgramNiepoprawny4()
        {
            Turing.SprawdProgram(program4);
        }

        [TestMethod]
        [ExpectedException(typeof(TuringException))]
        public void TestSprawdProgramNiepoprawny5()
        {
            Turing.SprawdProgram(program5);
        }

        [TestMethod]
        [ExpectedException(typeof(TuringException))]
        public void TestSprawdProgramNiepoprawny6()
        {
            Turing.SprawdProgram(program6);
        }

        [TestMethod]
        [ExpectedException(typeof(TuringException))]
        public void TestSprawdProgramNiepoprawny7()
        {
            Turing.SprawdProgram(program7);
        }

        [TestMethod]
        public void TestCzytajTam()
        {
            File.WriteAllText("test_tama.txt", zapisTamy1);
            string testTama = Turing.CzytajTam("test_tama.txt");
            Assert.AreEqual(zapisTamy1.Length, testTama.Length);
            for (int i = 0; i < program1.Length; i++)
            {
                Assert.AreEqual(zapisTamy1, testTama);
            }
        }

        [TestMethod]
        public void TestCzytajProgram()
        {
            File.WriteAllLines("test_program.txt", program1);
            string[] testProgram = Turing.CzytajProgram("test_program.txt");
            Assert.AreEqual(program1.Length, testProgram.Length);
            for(int i = 0; i < program1.Length; i++)
            {
                Assert.AreEqual(program1[i], testProgram[i]);
            }
        }

        [TestMethod]
        public void TestKonstruktora1()
        {
            string tama = "ABCEFGH";
            char stanGowicy = 'd';
            int pooenieGowicy = 3;
            string[] program = { "qABq", "qBRs", "sBCd" };

            Turing t = new Turing(tama.ToArray(), stanGowicy, pooenieGowicy, program);

            //Assert.AreEqual(tama, new string(t.tama));
            Assert.AreEqual(tama, new(t.tama));
            Assert.AreEqual(stanGowicy, t.stanGowicy);
            Assert.AreEqual(pooenieGowicy, t.pooenieGowicy);
            Assert.AreEqual(program, t.program);
        }

        [TestMethod]
        [ExpectedException(typeof(TuringException))]
        public void TestKonstruktora2()
        {
            Turing t = new Turing(null, '@', -1, null);
        }

        [TestMethod]
        public void TestZapisStanuMaszyny()
        {
            File.WriteAllText("test_tama1.txt", zapisTamy1);
            File.WriteAllLines("test_program1.txt", program1);
            Turing t = Turing.Load("test_tama1.txt", "test_program1.txt");
            t.ZapiszStanMaszyny("test_tama2.txt");
            string testTamy = File.ReadAllText("test_tama2.txt");
            Assert.AreEqual(zapisTamy1, testTamy);
        }
    }
}