﻿namespace ProgramowanieRównoległe
{
    internal class Program
    {
        private static int n = 10;

        private static double obliczenia(double argument)
        {
            for (int i = 0; i < n; ++i)
            {
                argument = Math.Asin(Math.Sin(argument));
            }
            return argument;
        }

        static void Main(string[] args)
        {
            int rozmiar = 10000;
            Random r = new Random();
            double[] tablica = new double[rozmiar];
            for(int i = 0; i < tablica.Length; i++) tablica[i] = r.NextDouble();

            //sekwencyjnie
            int liczbaPowtórzeń = 100;
            double[] wyniki = new double[tablica.Length];
            int start = System.Environment.TickCount;
            for (int powtórzenia = 0; powtórzenia < liczbaPowtórzeń; powtórzenia++) //dla poprawy pomiaru czasu
            {
                for (int i = 0; i < tablica.Length; ++i) 
                    wyniki[i] = obliczenia(tablica[i]);
            }
            int stop = System.Environment.TickCount;
            int duration1 = stop - start;
            Console.WriteLine($"Obliczenia sekwencyjne trwały {duration1} ms");

            start = System.Environment.TickCount;
            for (int powtórzenia = 0; powtórzenia < liczbaPowtórzeń; powtórzenia++) //dla poprawy pomiaru czasu
            {
                Parallel.For(
                    0,
                    tablica.Length,
                    (int i, ParallelLoopState stanPętli) =>
                    {
                        Console.WriteLine($"Wątek: {i} {Task.CurrentId} {Thread.CurrentThread.ManagedThreadId}");

                        wyniki[i] = obliczenia(tablica[i]);
                        /*
                        if (i == 100) stanPętli.Stop();

                        if (stanPętli.IsStopped)
                        {
                            Console.WriteLine("Wykryto prośbę o przerwanie pętli");
                            return;
                        }
                        */
                    });
            }
            stop = System.Environment.TickCount;
            int duration2 = stop - start;
            Console.WriteLine($"Obliczenia równoległe trwały {duration2} ms");

            Console.WriteLine($"Przyspieszenie: {duration1 / (double)duration2}");


        }
    }
}
