﻿namespace AsyncAwait
{    
    internal class Program
    {
        static Task<long> ZróbCośAsync(object argument)
        {
            Func<object, long> akcja =
                    (object argument) =>
                    {
                        Console.WriteLine($"{Thread.CurrentThread.ManagedThreadId} Początek działania akcji - " + argument.ToString());
                        Thread.Sleep(500);
                        Console.WriteLine($"{Thread.CurrentThread.ManagedThreadId} Koniec działania akcji - " + argument.ToString());
                        return DateTime.Now.Ticks;
                    };

            //long wynik = akcja("synchroniczny");
            //Console.WriteLine("Synchronicznie: " + wynik.ToString());

            Task<long> zadanie = new Task<long>(akcja, "zadanie");
            zadanie.Start();
            return zadanie;
        }


        static async void ProgramowanieAsynchroniczne()
        {
            Task<long> zadanie = ZróbCośAsync("zadanie-metoda");
            Console.WriteLine($"{Thread.CurrentThread.ManagedThreadId} Akcja została uruchomiona (metoda)");
            //long wynik = zadanie.Result;
            long wynik = await zadanie;
            Console.WriteLine($"{Thread.CurrentThread.ManagedThreadId} Zadanie-metoda: " + wynik.ToString());
        }

        static void Main(string[] args)
        {
            ProgramowanieAsynchroniczne();
            Console.WriteLine($"{Thread.CurrentThread.ManagedThreadId} Naciśnij Enter..."); Console.ReadLine();
            Console.WriteLine($"{Thread.CurrentThread.ManagedThreadId} Koniec.");
        }
    }
}
