﻿namespace WariancjaTypów
{
    class String2
    {
        public string s;

        public String2()
        {
            s = "---";
        }

        public String2(string s)
        {
            this.s = s;
        }
    }

    interface ITypInwariantny<T>
        where T : new()
    {
        void Nic();
        void PrzyjmijObiekt(T obiekt);
        T ZwróćObiekt();
        T PrzyjmijIZwróćObiekt(T obiekt);
    }

    class TypInwariantny<T> : ITypInwariantny<T>
        where T : new()
    {
        public void Nic()
        {
            Console.WriteLine("Nic");
        }

        public void PrzyjmijObiekt(T obiekt)
        {
            Console.WriteLine("Przyjmij obiekt, " + obiekt.ToString());
        }

        public T ZwróćObiekt()
        {
            T obiekt = new T();
            Console.WriteLine("Zwróć obiekt, " + obiekt.ToString());
            return obiekt;
        }

        public T PrzyjmijIZwróćObiekt(T obiekt)
        {
            Console.WriteLine("Przyjmij i zwróć obiekt, " + obiekt.ToString());
            return obiekt;
        }
    }

    interface ITypKontrawariantny<in T>
        where T : new()
    {
        void Nic();
        void PrzyjmijObiekt(T obiekt);
        //T ZwróćObiekt();
        //T PrzyjmijIZwróćObiekt(T obiekt);
    }

    class TypKontrawariantny<T> : ITypKontrawariantny<T>
        where T : new()
    {
        public void Nic()
        {
            Console.WriteLine("Nic");
        }

        public void PrzyjmijObiekt(T obiekt)
        {
            Console.WriteLine("Przyjmij obiekt, " + obiekt.ToString());
        }

        public T ZwróćObiekt()
        {
            T obiekt = new T();
            Console.WriteLine("Zwróć obiekt, " + obiekt.ToString());
            return obiekt;
        }

        public T PrzyjmijIZwróćObiekt(T obiekt)
        {
            Console.WriteLine("Przyjmij i zwróć obiekt, " + obiekt.ToString());
            return obiekt;
        }
    }

    interface ITypKowariantny<out T>
            where T : new()
    {
        void Nic();
        //void PrzyjmijObiekt(T obiekt);
        T ZwróćObiekt();
        //T PrzyjmijIZwróćObiekt(T obiekt);
    }

    class TypKowariantny<T> : ITypKowariantny<T>
        where T : new()
    {
        public void Nic()
        {
            Console.WriteLine("Nic");
        }

        public void PrzyjmijObiekt(T obiekt)
        {
            Console.WriteLine("Przyjmij obiekt, " + obiekt.ToString());
        }

        public T ZwróćObiekt()
        {
            T obiekt = new T();
            Console.WriteLine("Zwróć obiekt, " + obiekt.ToString());
            return obiekt;
        }

        public T PrzyjmijIZwróćObiekt(T obiekt)
        {
            Console.WriteLine("Przyjmij i zwróć obiekt, " + obiekt.ToString());
            return obiekt;
        }
    }

    internal class Program
    {
        static void Main(string[] args)
        {
            ITypInwariantny<object> o11 = new TypInwariantny<object>();
            TypInwariantny<object> o12 = new TypInwariantny<object>();

            ITypInwariantny<String2> o13 = new TypInwariantny<String2>();
            TypInwariantny<String2> o14 = new TypInwariantny<String2>();

            //ITypInwariantny<object> o15 = new TypInwariantny<String2>();
            //TypInwariantny<object> o16 = new TypInwariantny<String2>();

            //ITypInwariantny<String2> o17 = new TypInwariantny<object>();
            //TypInwariantny<String2> o18 = new TypInwariantny<object>();

            ITypKontrawariantny<object> o21 = new TypKontrawariantny<object>();
            TypKontrawariantny<object> o22 = new TypKontrawariantny<object>();

            ITypKontrawariantny<String2> o23 = new TypKontrawariantny<String2>();
            TypKontrawariantny<String2> o24 = new TypKontrawariantny<String2>();

            //ITypKowariantny<object> o25 = new TypKowariantny<String2>();
            //TypKowariantny<object> o26 = new TypKowariantny<String2>();

            ITypKontrawariantny<String2> o27 = new TypKontrawariantny<object>();
            //TypKowariantny<String2> o28 = new TypKowariantny<object>();

            o27.PrzyjmijObiekt(new String2("UMK"));

            ITypKowariantny<object> o31 = new TypKowariantny<object>();
            TypKowariantny<object> o32 = new TypKowariantny<object>();

            ITypKowariantny<String2> o33 = new TypKowariantny<String2>();
            TypKowariantny<String2> o34 = new TypKowariantny<String2>();

            ITypKowariantny<object> o35 = new TypKowariantny<String2>();
            //TypKowariantny<object> o36 = new TypKowariantny<String2>();

            //ITypKowariantny<String2> o37 = new TypKowariantny<object>();
            //TypKowariantny<String2> o38 = new TypKowariantny<object>();
        }
    }
}
