﻿namespace TypyOgólne
{
    class Para<T,S>
        : IComparable<Para<T,S>>
        where T : IComparable<T>
        where S: IComparable<S>
    {
        private T pierwszy = default(T);
        private S drugi = default(S);

        public Para(T pierwszy, S drugi)
        {
            this.pierwszy = pierwszy;
            this.drugi = drugi;
        }

        public override string ToString()
        {
            return pierwszy.ToString() + "\t" + drugi.ToString();
        }

        public int CompareTo(Para<T,S>? other)
        {
            if (other == null) throw new ArgumentNullException();
            int wynik = pierwszy.CompareTo(other.pierwszy);
            if (wynik != 0) return wynik;
            else return drugi.CompareTo(other.drugi);
        }
    }

    internal class Program
    {
        private static void pokażTablicę<T>(T[] tablica)
        {
            Console.WriteLine("Tablica:");
            foreach (T t in tablica)
                Console.WriteLine(t.ToString());
        }

        static void Main(string[] args)
        {
            Random r = new Random();
            int n = 3;
            
            Para<int,int>[] tpi = new Para<int,int>[n];
            for(int i = 0; i < n; ++i)
            {
                tpi[i] = new Para<int, int>(r.Next(10), r.Next(10));
            }
            pokażTablicę(tpi);

            Para<string,string>[] tps = new Para<string,string>[n];
            for (int i = 0; i < n; ++i)
            {
                tps[i] = new Para<string, string>(r.Next(10).ToString(), r.Next(10).ToString());
            }
            pokażTablicę(tps);

            Para<int, string>[] tpis = new Para<int, string>[n];
            for (int i = 0; i < n; ++i)
            {
                tpis[i] = new Para<int, string>(r.Next(10), r.Next(10).ToString());
            }
            pokażTablicę(tpis);

            Array.Sort(tpi);
            Array.Sort(tps);
            Array.Sort(tpis);

            pokażTablicę(tpi);
            pokażTablicę(tps);
            pokażTablicę(tpis);
        }
    }
}
