﻿namespace TypyOgólne
{
    class Para<T>
        : IComparable<Para<T>>
        where T : IComparable<T>        
    {
        private T pierwszy = default(T), drugi = default(T);

        public Para(T pierwszy, T drugi)
        {
            this.pierwszy = pierwszy;
            this.drugi = drugi;
        }

        public override string ToString()
        {
            return pierwszy.ToString() + "\t" + drugi.ToString();
        }

        public int CompareTo(Para<T>? other)
        {
            if (other == null) throw new ArgumentNullException();
            int wynik = pierwszy.CompareTo(other.pierwszy);
            if (wynik != 0) return wynik;
            else return drugi.CompareTo(other.drugi);
        }
    }

    internal class Program
    {
        private static void pokażTablicę<T>(T[] tablica)
        {
            Console.WriteLine("Tablica:");
            foreach (T t in tablica)
                Console.WriteLine(t.ToString());
        }

        static void Main(string[] args)
        {
            Random r = new Random();
            int n = 3;
            
            Para<int>[] tpi = new Para<int>[n];
            for(int i = 0; i < n; ++i)
            {
                tpi[i] = new Para<int>(r.Next(10), r.Next(10));
            }
            pokażTablicę(tpi);

            Para<string>[] tps = new Para<string>[n];
            for (int i = 0; i < n; ++i)
            {
                tps[i] = new Para<string>(r.Next(10).ToString(), r.Next(10).ToString());
            }
            pokażTablicę(tps);

            Array.Sort(tpi);
            Array.Sort(tps);

            pokażTablicę(tpi);
            pokażTablicę(tps);
        }
    }
}
