﻿using NaszEF.BazaDanych;
using System.Net;

namespace NaszEF
{
    internal class Program
    {
#if DEBUG
        static void podglądBazyDanych_Debug(BazaDanychOsób db)
        {
            try
            {
                Console.WriteLine("Podgląd bazy danych (DEBUG):");
                Console.WriteLine("Osoby:");
                foreach (Osoba osoba in db.Osoby)
                    Console.WriteLine("\t" + osoba.ToString());
                Console.WriteLine("Adresy:");
                foreach (Adres adres in db.Adresy)
                    Console.WriteLine("\t" + adres.ToString());
            }
            catch (Exception exc)
            {
                Console.Error.WriteLine("Błąd: " + exc.Message + "(" + typeof(Exception) + ")");
            }
        }
#endif

        static void podglądBazyDanych(BazaDanychOsób db)
        {
            Console.WriteLine("Podgląd bazy danych:");
            Console.WriteLine("Osoby:");
            List<Adres> adresy = new List<Adres>();
            foreach (int id in db.IdentyfikatoryOsób)
            {
                Osoba osoba = db.PobierzOsobę(id);
                adresy.Add(osoba.Adres);
                Console.WriteLine("\t" + osoba.ToString());
            }
            Console.WriteLine("Adresy:");
            foreach (Adres adres in adresy.Distinct().OrderBy(a => a.Id))
                Console.WriteLine("\t" + adres.ToString());
        }

        static void dodajPrzykładoweOsoby(BazaDanychOsób db)
        {
            Adres adres1 = new Adres() { Id = 1, Miasto = "Toruń", Ulica = "Grudziądzka", NumerDomu = 5, NumerMieszkania = 477 };
            Adres adres2 = new Adres() { Id = 2, Miasto = "Toruń", Ulica = "Św. Anna", NumerDomu = 4, NumerMieszkania = null };
            Osoba osoba1 = new Osoba() { Id = 0, Imię = "Jacek", Nazwisko = "Matulewski", NumerTelefonu = 87236428, Adres = adres1 };
            Osoba osoba2 = new Osoba() { Id = 0, Imię = "Piotr", Nazwisko = "Gładysz", NumerTelefonu = null, Adres = adres1 };
            Osoba osoba3 = new Osoba() { Id = 3, Imię = "Mikołaj", Nazwisko = "Kopernik", NumerTelefonu = 47865378, Adres = adres2 };
            
            db.DodajOsobę(osoba1);
            db.DodajOsobę(osoba2);
            db.DodajOsobę(osoba3);
        }


        static void Main(string[] args)
        {
            File.Delete("osoby.db");

            BazaDanychOsób bazaDanych = new BazaDanychOsób();
            podglądBazyDanych_Debug(bazaDanych);
            dodajPrzykładoweOsoby(bazaDanych);
            //podglądBazyDanych_Debug(bazaDanych);            
            podglądBazyDanych(bazaDanych);
            bazaDanych.UsuńOsobę(3);
            podglądBazyDanych(bazaDanych);
            Adres adres = bazaDanych.PobierzOsobę(2).Adres;
            bazaDanych.ZmieńDaneOsoby(2, new Osoba() { Imię = "Madame", Nazwisko = "Curie", Adres = adres });
            podglądBazyDanych(bazaDanych);

            var zapytanie = from Osoba osoba in bazaDanych.Osoby
                            select osoba.ToString();
            foreach(string s in zapytanie)
            {
                Console.WriteLine(s);
            }
        }
    }
}
