﻿using Microsoft.EntityFrameworkCore;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace NaszEF.BazaDanych
{
    internal class BazaDanychOsóbDbContext : DbContext
    {
        public DbSet<Osoba> Osoby { get; set; }
        public DbSet<Adres> Adresy { get; set; }

        protected override void OnConfiguring(DbContextOptionsBuilder optionsBuilder)
        {
            Console.WriteLine("BazaDanychOsóbDbContext.OnConfiguring");
            //base.OnConfiguring(optionsBuilder);
            optionsBuilder.UseSqlite("Data Source=osoby.db");
            //optionsBuilder.UseLazyLoadingProxies();
        }
    }

    public class BazaDanychOsób : IDisposable
    {
        private BazaDanychOsóbDbContext dbc = new BazaDanychOsóbDbContext();

        public BazaDanychOsób()
        {
            dbc.Database.EnsureCreated();
        }

        public void Dispose()
        {
            dbc.Dispose();
        }

        //CRUD
        //  UD
        public Osoba? PobierzOsobę(int idOsoby)
        {
            return dbc.Osoby.FirstOrDefault(o => o.Id == idOsoby);
        }

        public Osoba? this[int idOsoby]
        {
            get => PobierzOsobę(idOsoby);
        }

        public int[] IdentyfikatoryOsób
        {
            get
            {
                return dbc.Osoby.Select(o => o.Id).OrderBy(id => id).ToArray();
            }
        }

        public int DodajOsobę(Osoba osoba)
        {
            if (osoba == null) throw new ArgumentNullException("Podano pustą referencję do obiektu osoby jako argument");
            if (osoba.Adres == null) throw new ArgumentNullException("Podano pustą referencję do obiektu adresu jako argument");

            if (dbc.Osoby.ToArray().Any(o => o.Equals(osoba)))
                return osoba.Id; //id istniejącej osoby;
            else
            {
                //sami nadajemy id
                if (dbc.Osoby.Any(o => o.Id == osoba.Id))
                    osoba.Id = dbc.Osoby.Max(o => o.Id) + 1;
            }

            //dublowanie adresów
            Adres? adres = dbc.Adresy.ToArray().FirstOrDefault(a => a.Equals(osoba.Adres));
            if(adres != null) osoba.Adres = adres;

            //zapis
            dbc.Osoby.Add(osoba);
            dbc.SaveChanges();

            return osoba.Id;
        }

        private int[] pobierzIdentyfikatoryUżywanychAdresów()
        {
            return dbc.Osoby.Select(o => o.Adres.Id).Distinct().ToArray();
        }

        /*
        NIEPOTRZEBNE!!!
        private Adres[] pobierzNieużywaneAdresy()
        {
            int[] używaneIdAdresów = pobierzIdentyfikatoryUżywanychAdresów();
            List<Adres> nieużywaneAdresy = new List<Adres>();
            foreach(Adres adres in dbc.Adresy)
            {
                if(!używaneIdAdresów.Contains(adres.Id))
                    nieużywaneAdresy.Add(adres);
            }
            return nieużywaneAdresy.ToArray();
        }

        private void usuńNieużywaneAdresy()
        {
            dbc.Adresy.RemoveRange(pobierzNieużywaneAdresy());
            dbc.SaveChanges();
        }
        */

        public void UsuńOsobę(int idOsoby)
        {
            Osoba osoba = PobierzOsobę(idOsoby);
            if(osoba != null)
            {
                //tu można było po prostu usunąć osoba.Adres, później ustawiając null
                dbc.Osoby.Remove(osoba);
                dbc.SaveChanges();
                //usuńNieużywaneAdresy();
            }
        }

        public void ZmieńDaneOsoby(int idOsoby, Osoba noweDane)
        {
            Osoba osoba = PobierzOsobę(idOsoby);
            if (osoba == null) throw new ArgumentException("Identyfikator nie wskazuje osoby w bazie");
            osoba.Imię = noweDane.Imię;
            osoba.Nazwisko = noweDane.Nazwisko;
            osoba.NumerTelefonu = noweDane.NumerTelefonu;
            osoba.Adres = noweDane.Adres;
            noweDane.Id = osoba.Id; //dla spójności
            dbc.SaveChanges();
        }

        #region Debugowanie
#if DEBUG
        public Osoba[] Osoby { get { return dbc.Osoby.ToArray(); } }
        public Adres[] Adresy { get { return dbc.Adresy.ToArray(); } }
#endif
        #endregion
    }
}
