﻿using NaszEF.BazaDanych;

namespace NaszEF
{
    internal class Program
    {
        static void podglądBazyDanych(BazaDanychOsób db)
        {
            try
            {
                Console.WriteLine("\nPodgląd bazy danych:");
                Console.WriteLine("\nOsoby:");
                foreach (Osoba osoba in db.Osoby)
                    Console.WriteLine("\n\t" + osoba.ToString());
                Console.WriteLine("\nAdresy:");
                foreach (Adres adres in db.Adresy)
                    Console.WriteLine("\n\t" + adres.ToString());
            }
            catch (Exception exc)
            {
                Console.Error.WriteLine("Błąd: " + exc.Message + "(" + typeof(Exception) + ")");
            }
        }

        static void dodajPrzykładoweOsoby(BazaDanychOsób db)
        {
            Adres adres1 = new Adres() { Id = 1, Miasto = "Toruń", Ulica = "Grudziądzka", NumerDomu = 5, NumerMieszkania = 477 };
            Adres adres2 = new Adres() { Id = 2, Miasto = "Toruń", Ulica = "Św. Anna", NumerDomu = 4, NumerMieszkania = null };
            Osoba osoba1 = new Osoba() { Id = 0, Imię = "Jacek", Nazwisko = "Matulewski", NumerTelefonu = 87236428, Adres = adres1 };
            Osoba osoba2 = new Osoba() { Id = 0, Imię = "Piotr", Nazwisko = "Gładysz", NumerTelefonu = null, Adres = adres1 };
            Osoba osoba3 = new Osoba() { Id = 3, Imię = "Mikołaj", Nazwisko = "Kopernik", NumerTelefonu = 47865378, Adres = adres2 };
            
            db.DodajOsobę(osoba1);
            db.DodajOsobę(osoba2);
            db.DodajOsobę(osoba3);
        }


        static void Main(string[] args)
        {
            BazaDanychOsób bazaDanych = new BazaDanychOsób();
            podglądBazyDanych(bazaDanych);
            dodajPrzykładoweOsoby(bazaDanych);
            podglądBazyDanych(bazaDanych);
        }
    }
}
